/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Metrics;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.solver.ProblemFactChange;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.phase.Phase;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.solver.AbstractSolver;
import org.optaplanner.core.impl.solver.random.RandomFactory;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.optaplanner.core.impl.solver.termination.BasicPlumbingTermination;
import org.optaplanner.core.impl.solver.termination.Termination;

public class DefaultSolver<Solution_>
extends AbstractSolver<Solution_> {
    protected EnvironmentMode environmentMode;
    protected RandomFactory randomFactory;
    protected BasicPlumbingTermination<Solution_> basicPlumbingTermination;
    protected final AtomicBoolean solving = new AtomicBoolean(false);
    protected final SolverScope<Solution_> solverScope;
    private final String moveThreadCountDescription;
    private LongTaskTimer solveLengthTimer;
    private Counter errorCounter;

    public DefaultSolver(EnvironmentMode environmentMode, RandomFactory randomFactory, BestSolutionRecaller<Solution_> bestSolutionRecaller, BasicPlumbingTermination<Solution_> basicPlumbingTermination, Termination<Solution_> termination, List<Phase<Solution_>> phaseList, SolverScope<Solution_> solverScope, String moveThreadCountDescription) {
        super(bestSolutionRecaller, termination, phaseList);
        this.environmentMode = environmentMode;
        this.randomFactory = randomFactory;
        this.basicPlumbingTermination = basicPlumbingTermination;
        this.solverScope = solverScope;
        this.moveThreadCountDescription = moveThreadCountDescription;
        this.solveLengthTimer = Metrics.more().longTaskTimer("optaplanner.solver.solve-length", new String[0]);
        this.errorCounter = Metrics.counter((String)"optaplanner.solver.errors", (String[])new String[0]);
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public RandomFactory getRandomFactory() {
        return this.randomFactory;
    }

    public InnerScoreDirectorFactory<Solution_, ?> getScoreDirectorFactory() {
        return this.solverScope.getScoreDirector().getScoreDirectorFactory();
    }

    public BestSolutionRecaller<Solution_> getBestSolutionRecaller() {
        return this.bestSolutionRecaller;
    }

    public List<Phase<Solution_>> getPhaseList() {
        return this.phaseList;
    }

    public SolverScope<Solution_> getSolverScope() {
        return this.solverScope;
    }

    public long getTimeMillisSpent() {
        Long startingSystemTimeMillis = this.solverScope.getStartingSystemTimeMillis();
        if (startingSystemTimeMillis == null) {
            return 0L;
        }
        Long endingSystemTimeMillis = this.solverScope.getEndingSystemTimeMillis();
        if (endingSystemTimeMillis == null) {
            endingSystemTimeMillis = System.currentTimeMillis();
        }
        return endingSystemTimeMillis - startingSystemTimeMillis;
    }

    @Override
    public boolean isSolving() {
        return this.solving.get();
    }

    @Override
    public boolean terminateEarly() {
        boolean terminationEarlySuccessful = this.basicPlumbingTermination.terminateEarly();
        if (terminationEarlySuccessful) {
            this.logger.info("Terminating solver early.");
        }
        return terminationEarlySuccessful;
    }

    @Override
    public boolean isTerminateEarly() {
        return this.basicPlumbingTermination.isTerminateEarly();
    }

    @Override
    public boolean addProblemFactChange(ProblemFactChange<Solution_> problemFactChange) {
        return this.basicPlumbingTermination.addProblemFactChange(problemFactChange);
    }

    @Override
    public boolean addProblemFactChanges(List<ProblemFactChange<Solution_>> problemFactChangeList) {
        return this.basicPlumbingTermination.addProblemFactChanges(problemFactChangeList);
    }

    @Override
    public boolean isEveryProblemFactChangeProcessed() {
        return this.basicPlumbingTermination.isEveryProblemFactChangeProcessed();
    }

    @Override
    public final Solution_ solve(Solution_ problem) {
        if (problem == null) {
            throw new IllegalArgumentException("The problem (" + problem + ") must not be null.");
        }
        this.solverScope.setBestSolution(problem);
        this.outerSolvingStarted(this.solverScope);
        boolean restartSolver = true;
        while (restartSolver) {
            LongTaskTimer.Sample sample = this.solveLengthTimer.start();
            try {
                this.solvingStarted(this.solverScope);
                this.runPhases(this.solverScope);
                this.solvingEnded(this.solverScope);
            }
            catch (Exception e) {
                this.errorCounter.increment();
                throw e;
            }
            finally {
                sample.stop();
            }
            restartSolver = this.checkProblemFactChanges();
        }
        this.outerSolvingEnded(this.solverScope);
        return this.solverScope.getBestSolution();
    }

    public void outerSolvingStarted(SolverScope<Solution_> solverScope) {
        this.solving.set(true);
        this.basicPlumbingTermination.resetTerminateEarly();
        solverScope.setStartingSolverCount(0);
        solverScope.setWorkingRandom(this.randomFactory.createRandom());
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        solverScope.startingNow();
        solverScope.getScoreDirector().resetCalculationCount();
        super.solvingStarted(solverScope);
        int startingSolverCount = solverScope.getStartingSolverCount() + 1;
        solverScope.setStartingSolverCount(startingSolverCount);
        this.logger.info("Solving {}: time spent ({}), best score ({}), environment mode ({}), move thread count ({}), random ({}).", new Object[]{startingSolverCount == 1 ? "started" : "restarted", solverScope.calculateTimeMillisSpentUpToNow(), solverScope.getBestScore(), this.environmentMode.name(), this.moveThreadCountDescription, this.randomFactory != null ? this.randomFactory : "not fixed"});
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        solverScope.endingNow();
    }

    public void outerSolvingEnded(SolverScope<Solution_> solverScope) {
        solverScope.getScoreDirector().close();
        this.logger.info("Solving ended: time spent ({}), best score ({}), score calculation speed ({}/sec), phase total ({}), environment mode ({}), move thread count ({}).", new Object[]{solverScope.getTimeMillisSpent(), solverScope.getBestScore(), solverScope.getScoreCalculationSpeed(), this.phaseList.size(), this.environmentMode.name(), this.moveThreadCountDescription});
        this.solving.set(false);
    }

    private boolean checkProblemFactChanges() {
        boolean restartSolver = this.basicPlumbingTermination.waitForRestartSolverDecision();
        if (!restartSolver) {
            return false;
        }
        BlockingQueue<ProblemFactChange<Solution_>> problemFactChangeQueue = this.basicPlumbingTermination.startProblemFactChangesProcessing();
        this.solverScope.setWorkingSolutionFromBestSolution();
        Score score = null;
        int stepIndex = 0;
        ProblemFactChange problemFactChange = (ProblemFactChange)problemFactChangeQueue.poll();
        while (problemFactChange != null) {
            score = this.doProblemFactChange(problemFactChange, stepIndex);
            ++stepIndex;
            problemFactChange = (ProblemFactChange)problemFactChangeQueue.poll();
        }
        InnerScoreDirector<Solution_, ?> scoreDirector = this.solverScope.getScoreDirector();
        scoreDirector.assertNonNullPlanningIds();
        this.basicPlumbingTermination.endProblemFactChangesProcessing();
        this.bestSolutionRecaller.updateBestSolution(this.solverScope);
        this.logger.info("Real-time problem fact changes done: step total ({}), new best score ({}).", (Object)stepIndex, (Object)score);
        return true;
    }

    private Score doProblemFactChange(ProblemFactChange<Solution_> problemFactChange, int stepIndex) {
        problemFactChange.doChange(this.solverScope.getScoreDirector());
        Score score = this.solverScope.calculateScore();
        this.logger.debug("    Step index ({}), new score ({}) for real-time problem fact change.", (Object)stepIndex, (Object)score);
        return score;
    }
}

