/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.optaplanner.examples.common.experimental.api.Break;
import org.optaplanner.examples.common.experimental.api.ConsecutiveInfo;
import org.optaplanner.examples.common.experimental.api.Sequence;
import org.optaplanner.examples.common.experimental.impl.BreakImpl;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveDataImpl;
import org.optaplanner.examples.common.experimental.impl.MapValuesIterable;
import org.optaplanner.examples.common.experimental.impl.SequenceImpl;

public class ConsecutiveSetTree<Value_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>> {
    private final Function<Value_, Point_> indexFunction;
    private final BiFunction<Point_, Point_, Difference_> differenceFunction;
    private final BiFunction<Difference_, Difference_, Difference_> sumFunction;
    private final Difference_ maxDifference;
    private final Difference_ zeroDifference;
    private final Map<Value_, Integer> itemToCountMap;
    private final NavigableSet<Value_> itemSet;
    private final NavigableMap<Value_, SequenceImpl<Value_, Difference_>> startItemToSequence;
    private final NavigableMap<Value_, BreakImpl<Value_, Difference_>> startItemToPreviousBreak;
    private final MapValuesIterable<Value_, SequenceImpl<Value_, Difference_>> sequenceList;
    private final MapValuesIterable<Value_, BreakImpl<Value_, Difference_>> breakList;
    private final ConsecutiveDataImpl<Value_, Difference_> consecutiveData;

    public ConsecutiveSetTree(Function<Value_, Point_> indexFunction, BiFunction<Point_, Point_, Difference_> differenceFunction, BiFunction<Difference_, Difference_, Difference_> sumFunction, Difference_ maxDifference, Difference_ zeroDifference) {
        this.indexFunction = indexFunction;
        this.differenceFunction = differenceFunction;
        this.sumFunction = sumFunction;
        this.maxDifference = maxDifference;
        this.zeroDifference = zeroDifference;
        Comparator<Object> comparator = Comparator.comparing(indexFunction).thenComparing(System::identityHashCode);
        this.itemToCountMap = new IdentityHashMap<Value_, Integer>();
        this.itemSet = new TreeSet<Object>(comparator);
        this.startItemToSequence = new TreeMap<Object, SequenceImpl<Value_, Difference_>>(comparator);
        this.startItemToPreviousBreak = new TreeMap<Object, BreakImpl<Value_, Difference_>>(comparator);
        this.consecutiveData = new ConsecutiveDataImpl(this);
        this.sequenceList = new MapValuesIterable<SequenceImpl<Value_, Difference_>, SequenceImpl<SequenceImpl<Value_, Difference_>, Difference_>>(this.startItemToSequence);
        this.breakList = new MapValuesIterable<BreakImpl<Value_, Difference_>, BreakImpl<BreakImpl<Value_, Difference_>, Difference_>>(this.startItemToPreviousBreak);
    }

    public Iterable<Sequence<Value_, Difference_>> getConsecutiveSequences() {
        return this.sequenceList;
    }

    public Iterable<Break<Value_, Difference_>> getBreaks() {
        return this.breakList;
    }

    public ConsecutiveInfo<Value_, Difference_> getConsecutiveData() {
        return this.consecutiveData;
    }

    public boolean add(Value_ item) {
        int newCount = this.itemToCountMap.compute(item, (key, count) -> count == null ? 1 : count + 1);
        if (newCount > 1) {
            return true;
        }
        this.itemSet.add(item);
        Value_ firstBeforeItem = this.startItemToSequence.floorKey(item);
        Comparable itemIndex = (Comparable)this.indexFunction.apply(item);
        if (firstBeforeItem != null) {
            Value_ endOfBeforeSequenceItem = this.getEndItem(firstBeforeItem);
            Comparable endOfBeforeSequenceIndex = (Comparable)this.indexFunction.apply(endOfBeforeSequenceItem);
            if (this.isInNaturalOrderAndHashOrderIfEqual(itemIndex, item, endOfBeforeSequenceIndex, endOfBeforeSequenceItem)) {
                return true;
            }
            Value_ firstAfterItem = this.startItemToSequence.higherKey(item);
            if (firstAfterItem != null) {
                Comparable startOfAfterSequenceIndex = (Comparable)this.indexFunction.apply(firstAfterItem);
                this.addBetweenItems(item, itemIndex, firstBeforeItem, endOfBeforeSequenceItem, endOfBeforeSequenceIndex, firstAfterItem, startOfAfterSequenceIndex);
            } else {
                SequenceImpl prevBag = (SequenceImpl)this.startItemToSequence.get(firstBeforeItem);
                if (this.isFirstSuccessorOfSecond(itemIndex, item, endOfBeforeSequenceIndex, endOfBeforeSequenceItem)) {
                    prevBag.setEnd(item);
                } else {
                    SequenceImpl newBag = new SequenceImpl(this, item);
                    this.startItemToSequence.put(item, newBag);
                    this.startItemToPreviousBreak.put(item, new BreakImpl<Value_, Comparable>(prevBag, newBag, (Comparable)this.differenceFunction.apply(endOfBeforeSequenceIndex, itemIndex)));
                }
            }
        } else {
            Value_ firstAfterItem = this.startItemToSequence.higherKey(item);
            if (firstAfterItem != null) {
                Comparable startOfAfterSequenceIndex = (Comparable)this.indexFunction.apply(firstAfterItem);
                if (this.isFirstSuccessorOfSecond(startOfAfterSequenceIndex, firstAfterItem, itemIndex, item)) {
                    SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.remove(firstAfterItem);
                    afterBag.setStart(item);
                    this.startItemToSequence.put(item, afterBag);
                } else {
                    SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.get(firstAfterItem);
                    SequenceImpl newBag = new SequenceImpl(this, item);
                    this.startItemToSequence.put(item, newBag);
                    this.startItemToPreviousBreak.put(firstAfterItem, new BreakImpl<Value_, Comparable>(newBag, afterBag, (Comparable)this.differenceFunction.apply(itemIndex, startOfAfterSequenceIndex)));
                }
            } else {
                SequenceImpl newBag = new SequenceImpl(this, item);
                this.startItemToSequence.put(item, newBag);
            }
        }
        return true;
    }

    public boolean remove(Value_ item) {
        Integer currentCount = this.itemToCountMap.get(item);
        if (currentCount == null) {
            return false;
        }
        if (currentCount != 1) {
            this.itemToCountMap.put(item, currentCount - 1);
            return true;
        }
        this.itemToCountMap.remove(item);
        Value_ firstBeforeItem = this.startItemToSequence.floorKey(item);
        SequenceImpl bag = (SequenceImpl)this.startItemToSequence.get(firstBeforeItem);
        Object endItem = bag.getLastItem();
        this.itemSet.remove(item);
        if (bag.getFirstItem() == bag.getLastItem()) {
            this.startItemToSequence.remove(firstBeforeItem);
            BreakImpl removedBreak = (BreakImpl)this.startItemToPreviousBreak.remove(firstBeforeItem);
            Map.Entry<Value_, BreakImpl<Value_, Difference_>> extendedBreakEntry = this.startItemToPreviousBreak.higherEntry(firstBeforeItem);
            if (extendedBreakEntry != null) {
                if (removedBreak != null) {
                    BreakImpl extendedBreak = extendedBreakEntry.getValue();
                    extendedBreak.setPreviousSequence(removedBreak.getPreviousSequence());
                    this.updateLengthOfBreak(extendedBreak);
                } else {
                    this.startItemToPreviousBreak.remove(extendedBreakEntry.getKey());
                }
            }
            return true;
        }
        return this.removeItemFromBag(bag, item, firstBeforeItem, endItem);
    }

    protected NavigableSet<Value_> getItemSet() {
        return this.itemSet;
    }

    protected void updateLengthOfBreak(BreakImpl<Value_, Difference_> theBreak) {
        theBreak.setLength(this.getBreakLengthBetween(theBreak.getPreviousSequenceEnd(), theBreak.getNextSequenceStart()));
    }

    protected Difference_ getSequenceLength(Sequence<Value_, Difference_> sequence) {
        return (Difference_)((Comparable)this.sumFunction.apply(this.maxDifference, (Comparable)this.differenceFunction.apply((Comparable)this.indexFunction.apply(sequence.getFirstItem()), (Comparable)this.indexFunction.apply(sequence.getLastItem()))));
    }

    protected Difference_ getBreakLengthBetween(Value_ from, Value_ to) {
        return (Difference_)((Comparable)this.differenceFunction.apply((Comparable)this.indexFunction.apply(from), (Comparable)this.indexFunction.apply(to)));
    }

    protected Value_ getEndItem(Value_ key) {
        return ((SequenceImpl)this.startItemToSequence.get(key)).getLastItem();
    }

    private <T extends Comparable<T>> boolean isInNaturalOrderAndHashOrderIfEqual(T a, Value_ aItem, T b, Value_ bItem) {
        int difference = a.compareTo(b);
        if (difference != 0) {
            return difference < 0;
        }
        return System.identityHashCode(aItem) - System.identityHashCode(bItem) < 0;
    }

    private boolean isFirstSuccessorOfSecond(Point_ first, Value_ firstValue, Point_ second, Value_ secondValue) {
        Comparable difference = (Comparable)this.differenceFunction.apply(second, first);
        return this.isInNaturalOrderAndHashOrderIfEqual((Comparable)this.zeroDifference, secondValue, (Comparable)difference, firstValue) && difference.compareTo(this.maxDifference) <= 0;
    }

    private void addBetweenItems(Value_ item, Point_ itemIndex, Value_ firstBeforeItem, Value_ endOfBeforeSequenceItem, Point_ endOfBeforeSequenceItemIndex, Value_ firstAfterItem, Point_ startOfAfterSequenceIndex) {
        if (this.isFirstSuccessorOfSecond(itemIndex, item, endOfBeforeSequenceItemIndex, endOfBeforeSequenceItem)) {
            SequenceImpl prevBag = (SequenceImpl)this.startItemToSequence.get(firstBeforeItem);
            if (this.isFirstSuccessorOfSecond(startOfAfterSequenceIndex, firstAfterItem, itemIndex, item)) {
                this.startItemToPreviousBreak.remove(firstAfterItem);
                SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.remove(firstAfterItem);
                prevBag.merge(afterBag);
                Map.Entry<Value_, BreakImpl<Value_, Difference_>> maybeNextBreak = this.startItemToPreviousBreak.higherEntry(firstAfterItem);
                if (maybeNextBreak != null) {
                    maybeNextBreak.getValue().setPreviousSequence(prevBag);
                }
            } else {
                prevBag.setEnd(item);
                BreakImpl nextBreak = (BreakImpl)this.startItemToPreviousBreak.get(firstAfterItem);
                nextBreak.setLength((Comparable)this.differenceFunction.apply(itemIndex, startOfAfterSequenceIndex));
            }
        } else if (this.isFirstSuccessorOfSecond(startOfAfterSequenceIndex, firstAfterItem, itemIndex, item)) {
            SequenceImpl afterBag = (SequenceImpl)this.startItemToSequence.remove(firstAfterItem);
            afterBag.setStart(item);
            this.startItemToSequence.put(item, afterBag);
            BreakImpl prevBreak = (BreakImpl)this.startItemToPreviousBreak.remove(firstAfterItem);
            prevBreak.setLength((Comparable)this.differenceFunction.apply(endOfBeforeSequenceItemIndex, itemIndex));
            this.startItemToPreviousBreak.put(item, prevBreak);
        } else {
            SequenceImpl newBag = new SequenceImpl(this, item);
            this.startItemToSequence.put(item, newBag);
            BreakImpl nextBreak = (BreakImpl)this.startItemToPreviousBreak.get(firstAfterItem);
            nextBreak.setPreviousSequence(newBag);
            nextBreak.setLength((Comparable)this.differenceFunction.apply(itemIndex, startOfAfterSequenceIndex));
            this.startItemToPreviousBreak.put(item, new BreakImpl<Value_, Comparable>((Sequence)this.startItemToSequence.get(firstBeforeItem), newBag, (Comparable)this.differenceFunction.apply(endOfBeforeSequenceItemIndex, itemIndex)));
        }
    }

    private boolean removeItemFromBag(SequenceImpl<Value_, Difference_> bag, Value_ item, Value_ sequenceStart, Value_ sequenceEnd) {
        if (item.equals(sequenceStart)) {
            bag.setStart(this.itemSet.higher(item));
            this.startItemToSequence.remove(sequenceStart);
            BreakImpl extendedBreak = (BreakImpl)this.startItemToPreviousBreak.remove(sequenceStart);
            Value_ firstItem = bag.getFirstItem();
            this.startItemToSequence.put(firstItem, bag);
            if (extendedBreak != null) {
                this.updateLengthOfBreak(extendedBreak);
                this.startItemToPreviousBreak.put(firstItem, extendedBreak);
            }
            return true;
        }
        if (item.equals(sequenceEnd)) {
            bag.setEnd(this.itemSet.lower(item));
            Map.Entry<Value_, BreakImpl<Value_, Difference_>> extendedBreakEntry = this.startItemToPreviousBreak.higherEntry(item);
            if (extendedBreakEntry != null) {
                BreakImpl<Value_, Difference_> extendedBreak = extendedBreakEntry.getValue();
                this.updateLengthOfBreak(extendedBreak);
            }
            return true;
        }
        Value_ firstAfterItem = bag.getItems().higher(item);
        Value_ firstBeforeItem = bag.getItems().lower(item);
        if (this.isFirstSuccessorOfSecond((Comparable)this.indexFunction.apply(firstAfterItem), firstAfterItem, (Comparable)this.indexFunction.apply(firstBeforeItem), firstBeforeItem)) {
            return true;
        }
        SequenceImpl<Value_, Difference_> splitBag = bag.split(item);
        Value_ firstSplitItem = splitBag.getFirstItem();
        Value_ lastOriginalItem = bag.getLastItem();
        this.startItemToSequence.put(firstSplitItem, splitBag);
        this.startItemToPreviousBreak.put(firstSplitItem, new BreakImpl<Value_, Difference_>(bag, splitBag, this.getBreakLengthBetween(lastOriginalItem, firstSplitItem)));
        Map.Entry<Value_, BreakImpl<Value_, Difference_>> maybeNextBreak = this.startItemToPreviousBreak.higherEntry(firstAfterItem);
        if (maybeNextBreak != null) {
            maybeNextBreak.getValue().setPreviousSequence(splitBag);
        }
        return true;
    }
}

