/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.NavigableSet;
import java.util.Objects;
import java.util.stream.Collectors;
import org.optaplanner.examples.common.experimental.api.Sequence;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveSetTree;

class SequenceImpl<Value_, Difference_ extends Comparable<Difference_>>
implements Sequence<Value_, Difference_> {
    private final ConsecutiveSetTree<Value_, ?, Difference_> sourceTree;
    private Value_ firstItem;
    private Value_ lastItem;
    private Difference_ length;
    private NavigableSet<Value_> items;

    protected SequenceImpl(ConsecutiveSetTree<Value_, ?, Difference_> sourceTree, Value_ item) {
        this(sourceTree, item, item);
    }

    protected SequenceImpl(ConsecutiveSetTree<Value_, ?, Difference_> sourceTree, Value_ firstItem, Value_ lastItem) {
        this.sourceTree = sourceTree;
        this.firstItem = firstItem;
        this.lastItem = lastItem;
        this.length = null;
        this.items = null;
    }

    @Override
    public Value_ getFirstItem() {
        return this.firstItem;
    }

    @Override
    public Value_ getLastItem() {
        return this.lastItem;
    }

    @Override
    public NavigableSet<Value_> getItems() {
        if (this.items == null) {
            this.items = this.sourceTree.getItemSet().subSet(this.firstItem, true, this.lastItem, true);
            return this.items;
        }
        return this.items;
    }

    @Override
    public int getCount() {
        return this.getItems().size();
    }

    @Override
    public Difference_ getLength() {
        if (this.length == null) {
            this.length = this.sourceTree.getSequenceLength(this);
            return this.length;
        }
        return this.length;
    }

    protected void setStart(Value_ item) {
        this.firstItem = item;
        this.invalidate();
    }

    protected void setEnd(Value_ item) {
        this.lastItem = item;
        this.invalidate();
    }

    protected void invalidate() {
        this.length = null;
        this.items = null;
    }

    protected SequenceImpl<Value_, Difference_> split(Value_ fromElement) {
        Value_ newSequenceStart = this.sourceTree.getItemSet().higher(fromElement);
        Value_ newSequenceEnd = this.lastItem;
        this.lastItem = this.sourceTree.getItemSet().lower(fromElement);
        this.invalidate();
        return new SequenceImpl<Value_, Difference_>(this.sourceTree, newSequenceStart, newSequenceEnd);
    }

    protected void merge(SequenceImpl<Value_, Difference_> other) {
        this.lastItem = other.lastItem;
        this.invalidate();
    }

    public String toString() {
        return this.getItems().stream().map(Objects::toString).collect(Collectors.joining(", ", "Sequence [", "]"));
    }
}

