/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.solver.drools.functions;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.kie.api.runtime.rule.AccumulateFunction;

public class LoadBalanceAccumulateFunction
implements AccumulateFunction<LoadBalanceData> {
    public LoadBalanceData createContext() {
        return new LoadBalanceData();
    }

    public void init(LoadBalanceData data) {
        data.n = 0L;
        data.sum = 0L;
        data.squaredSum = 0L;
    }

    public void accumulate(LoadBalanceData data, Object o) {
        long value = (Long)o;
        ++data.n;
        data.sum += value;
        data.squaredSum += value * value;
    }

    public boolean supportsReverse() {
        return true;
    }

    public void reverse(LoadBalanceData data, Object o) {
        long value = (Long)o;
        --data.n;
        data.sum -= value;
        data.squaredSum -= value * value;
    }

    public Class<LoadBalanceResult> getResultType() {
        return LoadBalanceResult.class;
    }

    public LoadBalanceResult getResult(LoadBalanceData data) {
        return new LoadBalanceResult(data.n, data.sum, data.squaredSum);
    }

    public void writeExternal(ObjectOutput out) {
    }

    public void readExternal(ObjectInput in) {
    }

    public static class LoadBalanceResult
    implements Serializable {
        private final long n;
        private final long sum;
        private final long squaredSum;

        public LoadBalanceResult(long n, long sum, long squaredSum) {
            this.n = n;
            this.sum = sum;
            this.squaredSum = squaredSum;
        }

        public long getMeanDeviationSquaredSumRootMillis() {
            return this.getMeanDeviationSquaredSumRoot(1000.0);
        }

        public long getMeanDeviationSquaredSumRootMicros() {
            return this.getMeanDeviationSquaredSumRoot(1000000.0);
        }

        public long getMeanDeviationSquaredSumRoot(double scaleMultiplier) {
            double meanDeviationSquaredSum = (double)this.squaredSum - (double)(this.sum * this.sum) / (double)this.n;
            return (long)(Math.sqrt(meanDeviationSquaredSum) * scaleMultiplier);
        }
    }

    protected static class LoadBalanceData
    implements Serializable {
        private long n;
        private long sum;
        private long squaredSum;

        protected LoadBalanceData() {
        }
    }
}

