/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.solver.drools.functions;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.kie.api.runtime.rule.AccumulateFunction;

public class LoadBalanceByCountAccumulateFunction
implements AccumulateFunction<LoadBalanceByCountData> {
    public LoadBalanceByCountData createContext() {
        return new LoadBalanceByCountData();
    }

    public void init(LoadBalanceByCountData data) {
        data.groupCountMap = new HashMap<Object, Long>();
        data.squaredSum = 0L;
    }

    public void accumulate(LoadBalanceByCountData data, Object groupBy) {
        long count = data.groupCountMap.compute(groupBy, (key, value) -> value == null ? 1L : value + 1L);
        data.squaredSum += 2L * count - 1L;
    }

    public boolean supportsReverse() {
        return true;
    }

    public void reverse(LoadBalanceByCountData data, Object groupBy) {
        Long count = data.groupCountMap.compute(groupBy, (key, value) -> value == 1L ? null : Long.valueOf(value - 1L));
        data.squaredSum = data.squaredSum - (count == null ? 1L : 2L * count + 1L);
    }

    public Class<LoadBalanceByCountResult> getResultType() {
        return LoadBalanceByCountResult.class;
    }

    public LoadBalanceByCountResult getResult(LoadBalanceByCountData data) {
        return new LoadBalanceByCountResult(data.squaredSum);
    }

    public void writeExternal(ObjectOutput out) {
    }

    public void readExternal(ObjectInput in) {
    }

    public static class LoadBalanceByCountResult
    implements Serializable {
        private final long squaredSum;

        public LoadBalanceByCountResult(long squaredSum) {
            this.squaredSum = squaredSum;
        }

        public long getZeroDeviationSquaredSum() {
            return this.squaredSum;
        }

        public long getZeroDeviationSquaredSumRootMillis() {
            return this.getZeroDeviationSquaredSumRoot(1000.0);
        }

        public long getZeroDeviationSquaredSumRootMicros() {
            return this.getZeroDeviationSquaredSumRoot(1000000.0);
        }

        public long getZeroDeviationSquaredSumRoot(double scaleMultiplier) {
            return (long)(Math.sqrt(this.squaredSum) * scaleMultiplier);
        }
    }

    protected static class LoadBalanceByCountData
    implements Serializable {
        private Map<Object, Long> groupCountMap;
        private long squaredSum;

        protected LoadBalanceByCountData() {
        }
    }
}

