/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tennis.optional.score;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.core.impl.score.stream.bi.DefaultBiConstraintCollector;
import org.optaplanner.core.impl.score.stream.uni.DefaultUniConstraintCollector;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.tennis.domain.TeamAssignment;
import org.optaplanner.examples.tennis.domain.UnavailabilityPenalty;

public final class TennisConstraintProvider
implements ConstraintProvider {
    private static final String CONSTRAINT_PACKAGE = "org.optaplanner.examples.tennis.solver";

    private static <A> DefaultUniConstraintCollector<A, ?, LoadBalanceData> loadBalance(Function<A, Object> groupKey) {
        return new DefaultUniConstraintCollector(() -> new LoadBalanceData(), (resultContainer, a) -> {
            Object mapped = groupKey.apply(a);
            return resultContainer.apply(mapped);
        }, resultContainer -> resultContainer);
    }

    private static <A, B> DefaultBiConstraintCollector<A, B, ?, LoadBalanceData> loadBalance(BiFunction<A, B, Object> groupKey) {
        return new DefaultBiConstraintCollector(() -> new LoadBalanceData(), (resultContainer, a, b) -> {
            Object mapped = groupKey.apply(a, b);
            return resultContainer.apply(mapped);
        }, resultContainer -> resultContainer);
    }

    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.oneAssignmentPerDatePerTeam(constraintFactory), this.unavailabilityPenalty(constraintFactory), this.fairAssignmentCountPerTeam(constraintFactory), this.evenlyConfrontationCount(constraintFactory)};
    }

    protected Constraint oneAssignmentPerDatePerTeam(ConstraintFactory constraintFactory) {
        return constraintFactory.from(TeamAssignment.class).join(TeamAssignment.class, Joiners.equal(TeamAssignment::getTeam), Joiners.equal(TeamAssignment::getDay), Joiners.lessThan(AbstractPersistable::getId)).penalize(CONSTRAINT_PACKAGE, "oneAssignmentPerDatePerTeam", (Score)HardMediumSoftScore.ONE_HARD);
    }

    protected Constraint unavailabilityPenalty(ConstraintFactory constraintFactory) {
        return constraintFactory.from(UnavailabilityPenalty.class).ifExists(TeamAssignment.class, Joiners.equal(UnavailabilityPenalty::getTeam, TeamAssignment::getTeam), Joiners.equal(UnavailabilityPenalty::getDay, TeamAssignment::getDay)).penalize(CONSTRAINT_PACKAGE, "unavailabilityPenalty", (Score)HardMediumSoftScore.ONE_HARD);
    }

    protected Constraint fairAssignmentCountPerTeam(ConstraintFactory constraintFactory) {
        return constraintFactory.from(TeamAssignment.class).groupBy(TennisConstraintProvider.loadBalance(TeamAssignment::getTeam)).penalize(CONSTRAINT_PACKAGE, "fairAssignmentCountPerTeam", (Score)HardMediumSoftScore.ONE_MEDIUM, result -> (int)result.getZeroDeviationSquaredSumRootMillis());
    }

    protected Constraint evenlyConfrontationCount(ConstraintFactory constraintFactory) {
        return constraintFactory.from(TeamAssignment.class).join(TeamAssignment.class, Joiners.equal(TeamAssignment::getDay), Joiners.lessThan(assignment -> assignment.getTeam().getId())).groupBy(TennisConstraintProvider.loadBalance((A assignment, B otherAssignment) -> Pair.of((Object)assignment.getTeam(), (Object)otherAssignment.getTeam()))).penalize(CONSTRAINT_PACKAGE, "evenlyConfrontationCount", (Score)HardMediumSoftScore.ONE_SOFT, result -> (int)result.getZeroDeviationSquaredSumRootMillis());
    }

    private static final class LoadBalanceData {
        private final Map<Object, Long> groupCountMap = new LinkedHashMap<Object, Long>(0);
        private long squaredSum = 0L;

        private LoadBalanceData() {
        }

        private Runnable apply(Object mapped) {
            long count = this.groupCountMap.compute(mapped, (key, value) -> value == null ? 1L : value + 1L);
            this.squaredSum += 2L * count - 1L;
            return () -> {
                Long computed = this.groupCountMap.compute(mapped, (key, value) -> value == 1L ? null : Long.valueOf(value - 1L));
                this.squaredSum -= computed == null ? 1L : 2L * computed + 1L;
            };
        }

        public long getZeroDeviationSquaredSumRootMillis() {
            return (long)(Math.sqrt(this.squaredSum) * 1000.0);
        }
    }
}

