/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.persistence;

import java.io.IOException;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.optaplanner.examples.common.persistence.SolutionConverter;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.TspSolution;
import org.optaplanner.examples.tsp.domain.location.Location;
import org.optaplanner.examples.tsp.persistence.AbstractSvgTspOutputBuilder;

public class SvgTspLineAndCircleExporter
extends AbstractTxtSolutionExporter<TspSolution> {
    public static final String OUTPUT_FILE_SUFFIX = "line.svg";

    public static void main(String[] args) {
        SolutionConverter<TspSolution> converter = SolutionConverter.createExportConverter("tsp", TspSolution.class, new SvgTspLineAndCircleExporter());
        converter.convertAll();
    }

    @Override
    public String getOutputFileSuffix() {
        return OUTPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder<TspSolution> createTxtOutputBuilder() {
        return new SvgTspOutputBuilder();
    }

    public static class SvgTspOutputBuilder
    extends AbstractSvgTspOutputBuilder {
        @Override
        public void writeSolution() throws IOException {
            this.determineSizeAndOffset((TspSolution)this.solution);
            this.writeSvgHeader();
            this.bufferedWriter.write("<g stroke='black' stroke-width='1'>\n");
            double oldLat = 0.0;
            double oldLong = 0.0;
            AbstractPersistable standstill = ((TspSolution)this.solution).getDomicile();
            Location home = standstill.getLocation();
            while (standstill != null) {
                this.bufferedWriter.write("  <line x1='" + (oldLat + this.offsetX) + "' y1='" + (this.height - (oldLong + this.offsetY)) + "' ");
                Location location = standstill.getLocation();
                this.bufferedWriter.write("x2='" + (location.getLongitude() + this.offsetX) + "' y2='" + (this.height - (location.getLatitude() + this.offsetY)) + "' />\n");
                this.bufferedWriter.write("    <circle r='3' ");
                this.bufferedWriter.write("cx='" + (location.getLongitude() + this.offsetX) + "' cy='" + (this.height - (location.getLatitude() + this.offsetY)) + "' />\n");
                oldLat = location.getLongitude();
                oldLong = location.getLatitude();
                standstill = this.findNextVisit((Standstill)((Object)standstill));
            }
            this.bufferedWriter.write("  <line x1='" + (oldLat + this.offsetX) + "' y1='" + (this.height - (oldLong + this.offsetY)) + "' ");
            this.bufferedWriter.write("x2='" + (home.getLongitude() + this.offsetX) + "' y2='" + (this.height - (home.getLatitude() + this.offsetY)) + "' />n");
            this.bufferedWriter.write("</g>\n");
            this.bufferedWriter.write("</svg>\n");
        }
    }
}

