/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.EntityIndependentInitializedValueSelector;

public class InitializedValueSelector<Solution_>
extends AbstractValueSelector<Solution_> {
    protected final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected final ValueSelector<Solution_> childValueSelector;
    protected final boolean bailOutEnabled;

    public static <Solution_> ValueSelector<Solution_> create(ValueSelector<Solution_> valueSelector) {
        if (valueSelector instanceof EntityIndependentValueSelector) {
            return new EntityIndependentInitializedValueSelector((EntityIndependentValueSelector)valueSelector);
        }
        return new InitializedValueSelector<Solution_>(valueSelector);
    }

    protected InitializedValueSelector(ValueSelector<Solution_> childValueSelector) {
        this.variableDescriptor = childValueSelector.getVariableDescriptor();
        this.childValueSelector = childValueSelector;
        this.bailOutEnabled = childValueSelector.isNeverEnding();
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.childValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childValueSelector.isNeverEnding();
    }

    @Override
    public long getSize(Object entity) {
        return this.childValueSelector.getSize(entity);
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return new JustInTimeInitializedValueIterator(entity, this.childValueSelector.iterator(entity));
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return new JustInTimeInitializedValueIterator(entity, this.childValueSelector.endingIterator(entity));
    }

    protected long determineBailOutSize(Object entity) {
        if (!this.bailOutEnabled) {
            return -1L;
        }
        return this.childValueSelector.getSize(entity) * 10L;
    }

    protected boolean accept(Object value) {
        return value == null || !this.variableDescriptor.getEntityDescriptor().getEntityClass().isAssignableFrom(value.getClass()) || this.variableDescriptor.isInitialized(value);
    }

    public String toString() {
        return "Initialized(" + this.childValueSelector + ")";
    }

    protected class JustInTimeInitializedValueIterator
    extends UpcomingSelectionIterator<Object> {
        private final Iterator<Object> childValueIterator;
        private final long bailOutSize;

        public JustInTimeInitializedValueIterator(Object entity, Iterator<Object> childValueIterator) {
            this(childValueIterator, this$0.determineBailOutSize(entity));
        }

        public JustInTimeInitializedValueIterator(Iterator<Object> childValueIterator, long bailOutSize) {
            this.childValueIterator = childValueIterator;
            this.bailOutSize = bailOutSize;
        }

        @Override
        protected Object createUpcomingSelection() {
            Object next;
            long attemptsBeforeBailOut = this.bailOutSize;
            do {
                if (!this.childValueIterator.hasNext()) {
                    return this.noUpcomingSelection();
                }
                if (!InitializedValueSelector.this.bailOutEnabled) continue;
                if (attemptsBeforeBailOut <= 0L) {
                    InitializedValueSelector.this.logger.warn("Bailing out of neverEnding selector ({}) to avoid infinite loop.", (Object)InitializedValueSelector.this);
                    return this.noUpcomingSelection();
                }
                --attemptsBeforeBailOut;
            } while (!InitializedValueSelector.this.accept(next = this.childValueIterator.next()));
            return next;
        }
    }
}

