/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.aggregator.swingui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;

public class MixedCheckBox
extends JCheckBox {
    private String detail;
    private Object benchmarkResult;

    public MixedCheckBox() {
        this((String)null);
    }

    public MixedCheckBox(String text) {
        this(text, (String)null);
    }

    public MixedCheckBox(String text, String detail) {
        this(text, detail, null);
    }

    public MixedCheckBox(String text, String detail, Object benchmarkResult) {
        super(text);
        this.detail = detail;
        this.benchmarkResult = benchmarkResult;
        this.setModel(new MixedCheckBoxModel());
        this.setStatus(MixedCheckBoxStatus.UNCHECKED);
        this.addMouseListener(new CustomCheckboxMouseListener());
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Object getBenchmarkResult() {
        return this.benchmarkResult;
    }

    public void setBenchmarkResult(Object benchmarkResult) {
        this.benchmarkResult = benchmarkResult;
    }

    public MixedCheckBoxStatus getStatus() {
        return ((MixedCheckBoxModel)this.getModel()).getStatus();
    }

    public void setStatus(MixedCheckBoxStatus status) {
        ((MixedCheckBoxModel)this.getModel()).setStatus(status);
    }

    public static enum MixedCheckBoxStatus {
        CHECKED,
        UNCHECKED,
        MIXED;

    }

    private static class MixedCheckBoxModel
    extends JToggleButton.ToggleButtonModel {
        private MixedCheckBoxModel() {
        }

        private MixedCheckBoxStatus getStatus() {
            return this.isSelected() ? (this.isArmed() ? MixedCheckBoxStatus.MIXED : MixedCheckBoxStatus.CHECKED) : MixedCheckBoxStatus.UNCHECKED;
        }

        private void setStatus(MixedCheckBoxStatus status) {
            if (status == MixedCheckBoxStatus.CHECKED) {
                this.setSelected(true);
                this.setArmed(false);
                this.setPressed(false);
            } else if (status == MixedCheckBoxStatus.UNCHECKED) {
                this.setSelected(false);
                this.setArmed(false);
                this.setPressed(false);
            } else if (status == MixedCheckBoxStatus.MIXED) {
                this.setSelected(true);
                this.setArmed(true);
                this.setPressed(true);
            } else {
                throw new IllegalArgumentException("Invalid argument (" + status + ") supplied.");
            }
        }

        private void switchStatus() {
            switch (this.getStatus()) {
                case CHECKED: {
                    this.setStatus(MixedCheckBoxStatus.UNCHECKED);
                    break;
                }
                case UNCHECKED: {
                    this.setStatus(MixedCheckBoxStatus.CHECKED);
                    break;
                }
                case MIXED: {
                    this.setStatus(MixedCheckBoxStatus.CHECKED);
                    break;
                }
                default: {
                    throw new IllegalStateException("The status (" + this.getStatus() + ") is not implemented.");
                }
            }
        }
    }

    private class CustomCheckboxMouseListener
    extends MouseAdapter {
        private CustomCheckboxMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ((MixedCheckBoxModel)MixedCheckBox.this.getModel()).switchStatus();
        }
    }
}

