/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.result;

import java.io.File;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="plannerBenchmarkResult")
public class PlannerBenchmarkResult {
    private String name;
    private Boolean aggregation;
    @XmlTransient
    private File benchmarkReportDirectory;
    private Integer availableProcessors = null;
    private String loggingLevelOptaPlannerCore = null;
    private String loggingLevelDroolsCore = null;
    private Long maxMemory = null;
    private String optaPlannerVersion = null;
    private String javaVersion = null;
    private String javaVM = null;
    private String operatingSystem = null;
    private Integer parallelBenchmarkCount = null;
    private Long warmUpTimeMillisSpentLimit = null;
    private EnvironmentMode environmentMode = null;
    @XmlElement(name="solverBenchmarkResult")
    private List<SolverBenchmarkResult> solverBenchmarkResultList = null;
    @XmlElement(name="unifiedProblemBenchmarkResult")
    private List<ProblemBenchmarkResult> unifiedProblemBenchmarkResultList = null;
    private OffsetDateTime startingTimestamp = null;
    private Long benchmarkTimeMillisSpent = null;
    private Integer failureCount = null;
    private Long averageProblemScale = null;
    private Score averageScore = null;
    private SolverBenchmarkResult favoriteSolverBenchmarkResult = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(Boolean aggregation) {
        this.aggregation = aggregation;
    }

    public File getBenchmarkReportDirectory() {
        return this.benchmarkReportDirectory;
    }

    public void setBenchmarkReportDirectory(File benchmarkReportDirectory) {
        this.benchmarkReportDirectory = benchmarkReportDirectory;
    }

    public Integer getAvailableProcessors() {
        return this.availableProcessors;
    }

    public String getLoggingLevelOptaPlannerCore() {
        return this.loggingLevelOptaPlannerCore;
    }

    public String getLoggingLevelDroolsCore() {
        return this.loggingLevelDroolsCore;
    }

    public Long getMaxMemory() {
        return this.maxMemory;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getJavaVM() {
        return this.javaVM;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getOptaPlannerVersion() {
        return this.optaPlannerVersion;
    }

    public Integer getParallelBenchmarkCount() {
        return this.parallelBenchmarkCount;
    }

    public void setParallelBenchmarkCount(Integer parallelBenchmarkCount) {
        this.parallelBenchmarkCount = parallelBenchmarkCount;
    }

    public Long getWarmUpTimeMillisSpentLimit() {
        return this.warmUpTimeMillisSpentLimit;
    }

    public void setWarmUpTimeMillisSpentLimit(Long warmUpTimeMillisSpentLimit) {
        this.warmUpTimeMillisSpentLimit = warmUpTimeMillisSpentLimit;
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public List<SolverBenchmarkResult> getSolverBenchmarkResultList() {
        return this.solverBenchmarkResultList;
    }

    public void setSolverBenchmarkResultList(List<SolverBenchmarkResult> solverBenchmarkResultList) {
        this.solverBenchmarkResultList = solverBenchmarkResultList;
    }

    public List<ProblemBenchmarkResult> getUnifiedProblemBenchmarkResultList() {
        return this.unifiedProblemBenchmarkResultList;
    }

    public void setUnifiedProblemBenchmarkResultList(List<ProblemBenchmarkResult> unifiedProblemBenchmarkResultList) {
        this.unifiedProblemBenchmarkResultList = unifiedProblemBenchmarkResultList;
    }

    public OffsetDateTime getStartingTimestamp() {
        return this.startingTimestamp;
    }

    public void setStartingTimestamp(OffsetDateTime startingTimestamp) {
        this.startingTimestamp = startingTimestamp;
    }

    public Long getBenchmarkTimeMillisSpent() {
        return this.benchmarkTimeMillisSpent;
    }

    public void setBenchmarkTimeMillisSpent(Long benchmarkTimeMillisSpent) {
        this.benchmarkTimeMillisSpent = benchmarkTimeMillisSpent;
    }

    public Integer getFailureCount() {
        return this.failureCount;
    }

    public Long getAverageProblemScale() {
        return this.averageProblemScale;
    }

    public Score getAverageScore() {
        return this.averageScore;
    }

    public SolverBenchmarkResult getFavoriteSolverBenchmarkResult() {
        return this.favoriteSolverBenchmarkResult;
    }

    public boolean hasMultipleParallelBenchmarks() {
        return this.parallelBenchmarkCount == null || this.parallelBenchmarkCount > 1;
    }

    public boolean hasAnyFailure() {
        return this.failureCount > 0;
    }

    public int getMaximumSubSingleCount() {
        int maximumSubSingleCount = 0;
        for (ProblemBenchmarkResult problemBenchmarkResult : this.unifiedProblemBenchmarkResultList) {
            int problemMaximumSubSingleCount = problemBenchmarkResult.getMaximumSubSingleCount();
            if (problemMaximumSubSingleCount <= maximumSubSingleCount) continue;
            maximumSubSingleCount = problemMaximumSubSingleCount;
        }
        return maximumSubSingleCount;
    }

    public String findScoreLevelLabel(int scoreLevel) {
        String[] levelLabels = this.solverBenchmarkResultList.get(0).getScoreDefinition().getLevelLabels();
        if (scoreLevel >= levelLabels.length) {
            return "unknown-" + (scoreLevel - levelLabels.length);
        }
        return levelLabels[scoreLevel];
    }

    public String getStartingTimestampAsMediumString() {
        return this.startingTimestamp == null ? null : this.startingTimestamp.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM));
    }

    public void initBenchmarkReportDirectory(File benchmarkDirectory) {
        String timestampString = this.startingTimestamp.format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HHmmss"));
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            this.name = timestampString;
        }
        if (!benchmarkDirectory.mkdirs()) {
            if (!benchmarkDirectory.isDirectory()) {
                throw new IllegalArgumentException("The benchmarkDirectory (" + benchmarkDirectory + ") already exists, but is not a directory.");
            }
            if (!benchmarkDirectory.canWrite()) {
                throw new IllegalArgumentException("The benchmarkDirectory (" + benchmarkDirectory + ") already exists, but is not writable.");
            }
        }
        int duplicationIndex = 0;
        do {
            String directoryName = timestampString + (String)(duplicationIndex == 0 ? "" : "_" + duplicationIndex);
            ++duplicationIndex;
            this.benchmarkReportDirectory = new File(benchmarkDirectory, BooleanUtils.isFalse((Boolean)this.aggregation) ? directoryName : directoryName + "_aggregation");
        } while (!this.benchmarkReportDirectory.mkdir());
        for (ProblemBenchmarkResult problemBenchmarkResult : this.unifiedProblemBenchmarkResultList) {
            problemBenchmarkResult.makeDirs();
        }
    }

    public void initSystemProperties() {
        this.availableProcessors = Runtime.getRuntime().availableProcessors();
        this.loggingLevelOptaPlannerCore = this.resolveLoggingLevel("org.optaplanner.core");
        this.loggingLevelDroolsCore = this.resolveLoggingLevel("org.drools.core");
        this.maxMemory = Runtime.getRuntime().maxMemory();
        this.optaPlannerVersion = SolverFactory.class.getPackage().getImplementationVersion();
        if (this.optaPlannerVersion == null) {
            this.optaPlannerVersion = "Unjarred development snapshot";
        }
        this.javaVersion = "Java " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")";
        this.javaVM = "Java " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")";
        this.operatingSystem = System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
    }

    private String resolveLoggingLevel(String loggerName) {
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        if (logger.isTraceEnabled()) {
            return "trace";
        }
        if (logger.isDebugEnabled()) {
            return "debug";
        }
        if (logger.isInfoEnabled()) {
            return "info";
        }
        if (logger.isWarnEnabled()) {
            return "warn";
        }
        if (logger.isErrorEnabled()) {
            return "error";
        }
        throw new IllegalStateException("Logging level for loggerName (" + loggerName + ") cannot be determined.");
    }

    public int getTotalSubSingleCount() {
        int totalSubSingleCount = 0;
        for (ProblemBenchmarkResult problemBenchmarkResult : this.unifiedProblemBenchmarkResultList) {
            totalSubSingleCount += problemBenchmarkResult.getTotalSubSingleCount();
        }
        return totalSubSingleCount;
    }

    public void accumulateResults(BenchmarkReport benchmarkReport) {
        for (ProblemBenchmarkResult problemBenchmarkResult : this.unifiedProblemBenchmarkResultList) {
            problemBenchmarkResult.accumulateResults(benchmarkReport);
        }
        for (SolverBenchmarkResult solverBenchmarkResult : this.solverBenchmarkResultList) {
            solverBenchmarkResult.accumulateResults(benchmarkReport);
        }
        this.determineTotalsAndAverages();
        this.determineSolverRanking(benchmarkReport);
    }

    private void determineTotalsAndAverages() {
        this.failureCount = 0;
        long totalProblemScale = 0L;
        int problemScaleCount = 0;
        for (ProblemBenchmarkResult problemBenchmarkResult : this.unifiedProblemBenchmarkResultList) {
            Long problemScale = problemBenchmarkResult.getProblemScale();
            if (problemScale != null && problemScale >= 0L) {
                totalProblemScale += problemScale.longValue();
                ++problemScaleCount;
            }
            this.failureCount = this.failureCount + problemBenchmarkResult.getFailureCount();
        }
        this.averageProblemScale = problemScaleCount == 0 ? null : Long.valueOf(totalProblemScale / (long)problemScaleCount);
        Score totalScore = null;
        int solverBenchmarkCount = 0;
        boolean firstSolverBenchmarkResult = true;
        for (SolverBenchmarkResult solverBenchmarkResult : this.solverBenchmarkResultList) {
            Score score;
            EnvironmentMode solverEnvironmentMode = solverBenchmarkResult.getEnvironmentMode();
            if (firstSolverBenchmarkResult && solverEnvironmentMode != null) {
                this.environmentMode = solverEnvironmentMode;
                firstSolverBenchmarkResult = false;
            } else if (!firstSolverBenchmarkResult && solverEnvironmentMode != this.environmentMode) {
                this.environmentMode = null;
            }
            if ((score = solverBenchmarkResult.getAverageScore()) == null) continue;
            ScoreDefinition scoreDefinition = solverBenchmarkResult.getScoreDefinition();
            if (totalScore != null && !scoreDefinition.isCompatibleArithmeticArgument(totalScore)) {
                totalScore = null;
                break;
            }
            totalScore = totalScore == null ? score : totalScore.add(score);
            ++solverBenchmarkCount;
        }
        if (totalScore != null) {
            this.averageScore = totalScore.divide((double)solverBenchmarkCount);
        }
    }

    private void determineSolverRanking(BenchmarkReport benchmarkReport) {
        ArrayList<SolverBenchmarkResult> rankableSolverBenchmarkResultList = new ArrayList<SolverBenchmarkResult>(this.solverBenchmarkResultList);
        rankableSolverBenchmarkResultList.removeIf(SolverBenchmarkResult::hasAnyFailure);
        List<List<SolverBenchmarkResult>> sameRankingListList = this.createSameRankingListList(benchmarkReport, rankableSolverBenchmarkResultList);
        int ranking = 0;
        for (List<SolverBenchmarkResult> sameRankingList : sameRankingListList) {
            for (SolverBenchmarkResult solverBenchmarkResult : sameRankingList) {
                solverBenchmarkResult.setRanking(ranking);
            }
            ranking += sameRankingList.size();
        }
        this.favoriteSolverBenchmarkResult = sameRankingListList.isEmpty() ? null : sameRankingListList.get(0).get(0);
    }

    /*
     * WARNING - void declaration
     */
    private List<List<SolverBenchmarkResult>> createSameRankingListList(BenchmarkReport benchmarkReport, List<SolverBenchmarkResult> rankableSolverBenchmarkResultList) {
        ArrayList<List<SolverBenchmarkResult>> sameRankingListList = new ArrayList<List<SolverBenchmarkResult>>(rankableSolverBenchmarkResultList.size());
        if (benchmarkReport.getSolverRankingComparator() != null) {
            Comparator<SolverBenchmarkResult> comparator = Collections.reverseOrder(benchmarkReport.getSolverRankingComparator());
            rankableSolverBenchmarkResultList.sort(comparator);
            ArrayList<SolverBenchmarkResult> sameRankingList = null;
            Object var6_8 = null;
            for (SolverBenchmarkResult solverBenchmarkResult : rankableSolverBenchmarkResultList) {
                void var6_9;
                if (var6_9 == null || comparator.compare((SolverBenchmarkResult)var6_9, solverBenchmarkResult) != 0) {
                    sameRankingList = new ArrayList<SolverBenchmarkResult>();
                    sameRankingListList.add(sameRankingList);
                }
                sameRankingList.add(solverBenchmarkResult);
                SolverBenchmarkResult solverBenchmarkResult2 = solverBenchmarkResult;
            }
        } else if (benchmarkReport.getSolverRankingWeightFactory() != null) {
            TreeMap rankedMap = new TreeMap(Collections.reverseOrder());
            for (SolverBenchmarkResult solverBenchmarkResult : rankableSolverBenchmarkResultList) {
                Comparable rankingWeight = benchmarkReport.getSolverRankingWeightFactory().createRankingWeight(rankableSolverBenchmarkResultList, solverBenchmarkResult);
                List sameRankingList = rankedMap.computeIfAbsent(rankingWeight, k -> new ArrayList());
                sameRankingList.add(solverBenchmarkResult);
            }
            for (Map.Entry entry : rankedMap.entrySet()) {
                sameRankingListList.add((List)entry.getValue());
            }
        } else {
            throw new IllegalStateException("Ranking is impossible because solverRankingComparator and solverRankingWeightFactory are null.");
        }
        return sameRankingListList;
    }

    public static PlannerBenchmarkResult createMergedResult(List<SingleBenchmarkResult> singleBenchmarkResultList) {
        PlannerBenchmarkResult mergedResult = PlannerBenchmarkResult.createMergeSingleton(singleBenchmarkResultList);
        Map<SolverBenchmarkResult, SolverBenchmarkResult> solverMergeMap = SolverBenchmarkResult.createMergeMap(mergedResult, singleBenchmarkResultList);
        Map<ProblemBenchmarkResult, ProblemBenchmarkResult> problemMergeMap = ProblemBenchmarkResult.createMergeMap(mergedResult, singleBenchmarkResultList);
        for (SingleBenchmarkResult singleBenchmarkResult : singleBenchmarkResultList) {
            SolverBenchmarkResult solverBenchmarkResult = solverMergeMap.get(singleBenchmarkResult.getSolverBenchmarkResult());
            ProblemBenchmarkResult problemBenchmarkResult = problemMergeMap.get(singleBenchmarkResult.getProblemBenchmarkResult());
            SingleBenchmarkResult.createMerge(solverBenchmarkResult, problemBenchmarkResult, singleBenchmarkResult);
        }
        return mergedResult;
    }

    protected static PlannerBenchmarkResult createMergeSingleton(List<SingleBenchmarkResult> singleBenchmarkResultList) {
        PlannerBenchmarkResult newResult = null;
        IdentityHashMap<PlannerBenchmarkResult, PlannerBenchmarkResult> mergeMap = new IdentityHashMap<PlannerBenchmarkResult, PlannerBenchmarkResult>();
        for (SingleBenchmarkResult singleBenchmarkResult : singleBenchmarkResultList) {
            PlannerBenchmarkResult oldResult = singleBenchmarkResult.getSolverBenchmarkResult().getPlannerBenchmarkResult();
            if (mergeMap.containsKey(oldResult)) continue;
            if (newResult == null) {
                newResult = new PlannerBenchmarkResult();
                newResult.setAggregation(true);
                newResult.availableProcessors = oldResult.availableProcessors;
                newResult.loggingLevelOptaPlannerCore = oldResult.loggingLevelOptaPlannerCore;
                newResult.loggingLevelDroolsCore = oldResult.loggingLevelDroolsCore;
                newResult.maxMemory = oldResult.maxMemory;
                newResult.optaPlannerVersion = oldResult.optaPlannerVersion;
                newResult.javaVersion = oldResult.javaVersion;
                newResult.javaVM = oldResult.javaVM;
                newResult.operatingSystem = oldResult.operatingSystem;
                newResult.parallelBenchmarkCount = oldResult.parallelBenchmarkCount;
                newResult.warmUpTimeMillisSpentLimit = oldResult.warmUpTimeMillisSpentLimit;
                newResult.environmentMode = oldResult.environmentMode;
                newResult.solverBenchmarkResultList = new ArrayList<SolverBenchmarkResult>();
                newResult.unifiedProblemBenchmarkResultList = new ArrayList<ProblemBenchmarkResult>();
                newResult.startingTimestamp = null;
                newResult.benchmarkTimeMillisSpent = null;
            } else {
                newResult.availableProcessors = (Integer)ConfigUtils.mergeProperty((Object)newResult.availableProcessors, (Object)oldResult.availableProcessors);
                newResult.loggingLevelOptaPlannerCore = (String)ConfigUtils.mergeProperty((Object)newResult.loggingLevelOptaPlannerCore, (Object)oldResult.loggingLevelOptaPlannerCore);
                newResult.loggingLevelDroolsCore = (String)ConfigUtils.mergeProperty((Object)newResult.loggingLevelDroolsCore, (Object)oldResult.loggingLevelDroolsCore);
                newResult.maxMemory = (Long)ConfigUtils.mergeProperty((Object)newResult.maxMemory, (Object)oldResult.maxMemory);
                newResult.optaPlannerVersion = (String)ConfigUtils.mergeProperty((Object)newResult.optaPlannerVersion, (Object)oldResult.optaPlannerVersion);
                newResult.javaVersion = (String)ConfigUtils.mergeProperty((Object)newResult.javaVersion, (Object)oldResult.javaVersion);
                newResult.javaVM = (String)ConfigUtils.mergeProperty((Object)newResult.javaVM, (Object)oldResult.javaVM);
                newResult.operatingSystem = (String)ConfigUtils.mergeProperty((Object)newResult.operatingSystem, (Object)oldResult.operatingSystem);
                newResult.parallelBenchmarkCount = (Integer)ConfigUtils.mergeProperty((Object)newResult.parallelBenchmarkCount, (Object)oldResult.parallelBenchmarkCount);
                newResult.warmUpTimeMillisSpentLimit = (Long)ConfigUtils.mergeProperty((Object)newResult.warmUpTimeMillisSpentLimit, (Object)oldResult.warmUpTimeMillisSpentLimit);
                newResult.environmentMode = (EnvironmentMode)ConfigUtils.mergeProperty((Object)newResult.environmentMode, (Object)oldResult.environmentMode);
            }
            mergeMap.put(oldResult, newResult);
        }
        return newResult;
    }

    public static PlannerBenchmarkResult createUnmarshallingFailedResult(String benchmarkReportDirectoryName) {
        PlannerBenchmarkResult result = new PlannerBenchmarkResult();
        result.setName("Failed unmarshalling " + benchmarkReportDirectoryName);
        result.setSolverBenchmarkResultList(Collections.emptyList());
        result.setUnifiedProblemBenchmarkResultList(Collections.emptyList());
        return result;
    }

    public String toString() {
        return this.getName();
    }
}

