/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.constraint;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;

public final class DefaultConstraintMatchTotal<Score_ extends Score<Score_>>
implements ConstraintMatchTotal<Score_>,
Comparable<DefaultConstraintMatchTotal<Score_>> {
    private static final Comparator<DefaultConstraintMatchTotal<?>> COMPARATOR = Comparator.comparing(constraintMatchTotal -> constraintMatchTotal.constraintPackage).thenComparing(DefaultConstraintMatchTotal::getConstraintName);
    private final String constraintPackage;
    private final String constraintName;
    private final Score_ constraintWeight;
    private final Set<ConstraintMatch<Score_>> constraintMatchSet = new LinkedHashSet<ConstraintMatch<Score_>>();
    private Score_ score;

    public DefaultConstraintMatchTotal(String constraintPackage, String constraintName, Score_ zeroScore) {
        this(constraintPackage, constraintName, null, zeroScore);
    }

    public DefaultConstraintMatchTotal(String constraintPackage, String constraintName, Score_ constraintWeight, Score_ zeroScore) {
        this.constraintPackage = Objects.requireNonNull(constraintPackage);
        this.constraintName = Objects.requireNonNull(constraintName);
        this.constraintWeight = constraintWeight;
        this.score = (Score)Objects.requireNonNull(zeroScore);
    }

    @Override
    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    @Override
    public String getConstraintName() {
        return this.constraintName;
    }

    @Override
    public Score_ getConstraintWeight() {
        return this.constraintWeight;
    }

    @Override
    public Set<ConstraintMatch<Score_>> getConstraintMatchSet() {
        return this.constraintMatchSet;
    }

    @Override
    public Score_ getScore() {
        return this.score;
    }

    public ConstraintMatch<Score_> addConstraintMatch(List<Object> justificationList, Score_ score) {
        this.score = this.score.add(score);
        ConstraintMatch<Score_> constraintMatch = new ConstraintMatch<Score_>(this.constraintPackage, this.constraintName, justificationList, score);
        boolean added = this.constraintMatchSet.add(constraintMatch);
        if (!added) {
            throw new IllegalStateException("The constraintMatchTotal (" + this + ") could not add constraintMatch (" + constraintMatch + ") to its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
        return constraintMatch;
    }

    public void removeConstraintMatch(ConstraintMatch<Score_> constraintMatch) {
        this.score = this.score.subtract(constraintMatch.getScore());
        boolean removed = this.constraintMatchSet.remove(constraintMatch);
        if (!removed) {
            throw new IllegalStateException("The constraintMatchTotal (" + this + ") could not remove constraintMatch (" + constraintMatch + ") from its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
    }

    @Override
    public String getConstraintId() {
        return ConstraintMatchTotal.composeConstraintId(this.constraintPackage, this.constraintName);
    }

    @Override
    public int compareTo(DefaultConstraintMatchTotal<Score_> other) {
        return COMPARATOR.compare(this, other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DefaultConstraintMatchTotal) {
            DefaultConstraintMatchTotal other = (DefaultConstraintMatchTotal)o;
            return this.constraintPackage.equals(other.constraintPackage) && this.constraintName.equals(other.constraintName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.constraintPackage, this.constraintName);
    }

    public String toString() {
        return this.getConstraintId() + "=" + this.score;
    }
}

