/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.drools.model.Argument;
import org.drools.model.Drools;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.ConsequenceMatchWeightType;
import org.optaplanner.core.impl.score.stream.drools.common.FactTuple;
import org.optaplanner.core.impl.score.stream.drools.common.RuleAssembly;

public abstract class AbstractConstraintConsequence<LeftHandSide_ extends AbstractLeftHandSide> {
    protected abstract LeftHandSide_ getLeftHandSide();

    protected abstract ConsequenceMatchWeightType getMatchWeightType();

    public abstract int getCardinality();

    protected abstract ConsequenceBuilder.ValidBuilder buildConsequence(DroolsConstraint<?> var1, Global<? extends AbstractScoreHolder<?>> var2, Variable<?> ... var3);

    protected final Stream<Class<?>> getExpectedJustificationTypes() {
        Variable[] variables = ((AbstractLeftHandSide)this.getLeftHandSide()).getVariables();
        Variable lastVariable = variables[variables.length - 1];
        Class type = lastVariable.getType();
        if (FactTuple.class.isAssignableFrom(type)) {
            return Stream.of(type);
        }
        return Arrays.stream(variables).map(Argument::getType);
    }

    public final <Solution_> RuleAssembly assemble(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, DroolsConstraint<Solution_> constraint) {
        LeftHandSide_ leftHandSide = this.getLeftHandSide();
        Object[] variables = ((AbstractLeftHandSide)leftHandSide).getVariables();
        int expectedVariableCount = this.getCardinality();
        int actualVariableCount = variables.length;
        if (variables.length != this.getCardinality()) {
            throw new IllegalStateException("Impossible state: Constraint (" + constraint.getConstraintId() + ") expects (" + expectedVariableCount + ") variables but got (" + actualVariableCount + "): (" + Arrays.toString(variables) + ").");
        }
        ConsequenceBuilder.ValidBuilder consequence = this.buildConsequence(constraint, scoreHolderGlobal, (Variable<?>[])variables);
        ArrayList<ConsequenceBuilder.ValidBuilder> ruleItemBuilderList = new ArrayList<ConsequenceBuilder.ValidBuilder>((Collection)leftHandSide.get());
        ruleItemBuilderList.add(consequence);
        Rule rule = PatternDSL.rule((String)constraint.getConstraintPackage(), (String)constraint.getConstraintName()).build(ruleItemBuilderList.toArray(new RuleItemBuilder[0]));
        return new RuleAssembly(rule, (Class[])this.getExpectedJustificationTypes().toArray(Class[]::new));
    }

    protected static void impactScore(Drools drools, AbstractScoreHolder<?> scoreHolder) {
        scoreHolder.impactScore((RuleContext)drools);
    }

    protected static void impactScore(DroolsConstraint<?> constraint, Drools drools, AbstractScoreHolder<?> scoreHolder, int impact) {
        constraint.assertCorrectImpact(impact);
        scoreHolder.impactScore((RuleContext)drools, impact);
    }

    protected static void impactScore(DroolsConstraint<?> constraint, Drools drools, AbstractScoreHolder<?> scoreHolder, long impact) {
        constraint.assertCorrectImpact(impact);
        scoreHolder.impactScore((RuleContext)drools, impact);
    }

    protected static void impactScore(DroolsConstraint<?> constraint, Drools drools, AbstractScoreHolder<?> scoreHolder, BigDecimal impact) {
        constraint.assertCorrectImpact(impact);
        scoreHolder.impactScore((RuleContext)drools, impact);
    }
}

