/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.utils;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedProperties
implements Externalizable,
Cloneable {
    protected static transient Logger logger = LoggerFactory.getLogger(ChainedProperties.class);
    private List<Properties> props = new ArrayList<Properties>();
    private List<Properties> defaultProps = new ArrayList<Properties>();

    public ChainedProperties() {
    }

    public static ChainedProperties getChainedProperties(ClassLoader classLoader) {
        return ChainedProperties.getChainedProperties("properties.conf", classLoader);
    }

    public static ChainedProperties getChainedProperties(String confFileName, ClassLoader classLoader) {
        return new ChainedProperties(confFileName, classLoader);
    }

    public ChainedProperties clone() {
        ChainedProperties clone = new ChainedProperties();
        clone.props.addAll(this.props);
        clone.defaultProps.addAll(this.defaultProps);
        return clone;
    }

    private ChainedProperties(String confFileName, ClassLoader classLoader) {
        this.addProperties(System.getProperties());
        this.loadProperties("META-INF/kie." + confFileName, classLoader, this.props);
        this.loadProperties("META-INF/kie.default." + confFileName, classLoader, this.defaultProps);
        if (this.defaultProps.isEmpty()) {
            try {
                Class<?> c = Class.forName("org.drools.core.WorkingMemory", false, classLoader);
                URL confURL = c.getResource("/META-INF/kie.default." + confFileName);
                this.loadProperties(confURL, this.defaultProps);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.props = (List)in.readObject();
        this.defaultProps = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.props);
        out.writeObject(this.defaultProps);
    }

    public void addProperties(Properties properties) {
        this.props.add(0, properties);
    }

    public String getProperty(String key, String defaultValue) {
        String value;
        block2: {
            Properties props;
            value = null;
            Iterator<Properties> iterator = this.props.iterator();
            while (iterator.hasNext() && (value = (props = iterator.next()).getProperty(key)) == null) {
            }
            if (value != null) break block2;
            iterator = this.defaultProps.iterator();
            while (iterator.hasNext() && (value = (props = iterator.next()).getProperty(key)) == null) {
            }
        }
        return value != null ? value : defaultValue;
    }

    public void mapStartsWith(Map<String, String> map, String startsWith, boolean includeSubProperties) {
        for (Properties props : this.props) {
            this.mapStartsWith(map, props, startsWith, includeSubProperties);
        }
        for (Properties props : this.defaultProps) {
            this.mapStartsWith(map, props, startsWith, includeSubProperties);
        }
    }

    private void mapStartsWith(Map<String, String> map, Properties properties, String startsWith, boolean includeSubProperties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(startsWith) || !includeSubProperties && key.substring(startsWith.length() + 1).indexOf(46) > 0 || map.containsKey(key)) continue;
            map.put(key, properties.getProperty(key));
        }
    }

    private void loadProperties(String fileName, ClassLoader classLoader, List<Properties> chain) {
        try {
            chain.addAll(this.read(fileName, classLoader));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<Properties> read(String fileName, ClassLoader classLoader) throws IOException {
        ArrayList<Properties> properties = new ArrayList<Properties>();
        Enumeration<URL> resources = classLoader != null ? classLoader.getResources(fileName) : Collections.enumeration(Collections.singletonList(new File(fileName).toURI().toURL()));
        while (resources.hasMoreElements()) {
            Properties p = new Properties();
            URL nextElement = resources.nextElement();
            InputStream is = nextElement.openStream();
            try {
                p.load(is);
                properties.add(p);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return properties;
    }

    private void loadProperties(URL confURL, List<Properties> chain) {
        if (confURL == null) {
            return;
        }
        try (InputStream is = confURL.openStream();){
            Properties properties = new Properties();
            properties.load(is);
            chain.add(properties);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

