/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.persistence.util;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

public class VehicleRoutingDistanceTypeComparison
extends LoggingMain {
    private final ScoreManager<VehicleRoutingSolution, HardSoftLongScore> scoreManager;
    protected final File dataDir = CommonApp.determineDataDir("vehiclerouting");
    protected final SolutionFileIO<VehicleRoutingSolution> solutionFileIO = new XStreamSolutionFileIO(new Class[]{VehicleRoutingSolution.class});

    public static void main(String[] args) {
        new VehicleRoutingDistanceTypeComparison().compare("solved/tmp-p-belgium-n50-k10.xml", "solved/tmp-p-belgium-road-km-n50-k10.xml", "solved/tmp-p-belgium-road-time-n50-k10.xml");
    }

    public VehicleRoutingDistanceTypeComparison() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/vehiclerouting/solver/vehicleRoutingSolverConfig.xml");
        this.scoreManager = ScoreManager.create((SolverFactory)solverFactory);
    }

    public void compare(String ... filePaths) {
        File[] files = new File[filePaths.length];
        for (int i = 0; i < filePaths.length; ++i) {
            File file = new File(this.dataDir, filePaths[i]);
            if (!file.exists()) {
                throw new IllegalArgumentException("The file (" + file + ") does not exist.");
            }
            files[i] = file;
        }
        for (File varFile : files) {
            this.logger.info("  Results for {}:", (Object)varFile.getName());
            VehicleRoutingSolution variablesSolution = (VehicleRoutingSolution)this.solutionFileIO.read(varFile);
            for (File inputFile : files) {
                HardSoftLongScore score;
                if (inputFile == varFile) {
                    score = variablesSolution.getScore();
                } else {
                    VehicleRoutingSolution inputSolution = (VehicleRoutingSolution)this.solutionFileIO.read(inputFile);
                    this.applyVariables(inputSolution, variablesSolution);
                    score = inputSolution.getScore();
                }
                this.logger.info("    {} (according to {})", (Object)score.getSoftScore(), (Object)inputFile.getName());
            }
        }
    }

    private void applyVariables(VehicleRoutingSolution inputSolution, VehicleRoutingSolution varSolution) {
        List<Vehicle> inputVehicleList = inputSolution.getVehicleList();
        LinkedHashMap<Long, Vehicle> inputVehicleMap = new LinkedHashMap<Long, Vehicle>(inputVehicleList.size());
        for (Vehicle vehicle : inputVehicleList) {
            inputVehicleMap.put(vehicle.getId(), vehicle);
        }
        List<Customer> inputCustomerList = inputSolution.getCustomerList();
        LinkedHashMap<Long, Customer> inputCustomerMap = new LinkedHashMap<Long, Customer>(inputCustomerList.size());
        for (Customer customer : inputCustomerList) {
            inputCustomerMap.put(customer.getId(), customer);
        }
        for (Vehicle varVehicle : varSolution.getVehicleList()) {
            Vehicle inputVehicle = (Vehicle)inputVehicleMap.get(varVehicle.getId());
            Customer varNext = varVehicle.getNextCustomer();
            inputVehicle.setNextCustomer(varNext == null ? null : (Customer)inputCustomerMap.get(varNext.getId()));
        }
        for (Customer varCustomer : varSolution.getCustomerList()) {
            Customer inputCustomer = (Customer)inputCustomerMap.get(varCustomer.getId());
            Standstill varPrevious = varCustomer.getPreviousStandstill();
            inputCustomer.setPreviousStandstill(varPrevious == null ? null : (varPrevious instanceof Vehicle ? (Standstill)inputVehicleMap.get(((Vehicle)varPrevious).getId()) : (Standstill)inputCustomerMap.get(((Customer)varPrevious).getId())));
            Customer varNext = varCustomer.getNextCustomer();
            inputCustomer.setNextCustomer(varNext == null ? null : (Customer)inputCustomerMap.get(varNext.getId()));
        }
        this.scoreManager.updateScore((Object)inputSolution);
    }
}

