/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.factory;

import java.util.Iterator;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.AbstractMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveIteratorFactory;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;

public class MoveIteratorFactoryToMoveSelectorBridge<Solution_>
extends AbstractMoveSelector<Solution_> {
    protected final MoveIteratorFactory<Solution_, ?> moveIteratorFactory;
    protected final boolean randomSelection;
    protected ScoreDirector<Solution_> scoreDirector = null;

    public MoveIteratorFactoryToMoveSelectorBridge(MoveIteratorFactory<Solution_, ?> moveIteratorFactory, boolean randomSelection) {
        this.moveIteratorFactory = moveIteratorFactory;
        this.randomSelection = randomSelection;
    }

    @Override
    public boolean supportsPhaseAndSolverCaching() {
        return true;
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        long size = this.moveIteratorFactory.getSize(this.scoreDirector);
        if (size < 0L) {
            throw new IllegalStateException("The moveIteratorFactoryClass (" + this.moveIteratorFactory.getClass() + ") has size (" + size + ") which is negative, but a correct size is required in this Solver configuration.");
        }
        return size;
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        if (!this.randomSelection) {
            return this.moveIteratorFactory.createOriginalMoveIterator(this.scoreDirector);
        }
        return this.moveIteratorFactory.createRandomMoveIterator(this.scoreDirector, this.workingRandom);
    }

    public String toString() {
        return "MoveIteratorFactory(" + this.moveIteratorFactory.getClass() + ")";
    }
}

