/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import org.drools.model.DSL;
import org.drools.model.Global;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block4;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.BiLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.ConsequenceMatchWeightType;

abstract class AbstractBiConstraintConsequence<A, B>
extends AbstractConstraintConsequence<BiLeftHandSide<A, B>> {
    AbstractBiConstraintConsequence() {
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    @Override
    public abstract ConsequenceMatchWeightType getMatchWeightType();

    @Override
    protected final ConsequenceBuilder.ValidBuilder buildConsequence(DroolsConstraint<?> constraint, Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, Variable<?> ... variables) {
        AbstractConstraintConsequence consequence = constraint.getConsequence();
        switch (consequence.getMatchWeightType()) {
            case INTEGER: {
                ToIntBiFunction intMatchWeighter = (ToIntBiFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, variables[0], variables[1]).execute((Block4 & Serializable)(drools, scoreHolder, a, b) -> AbstractBiConstraintConsequence.impactScore(constraint, drools, scoreHolder, intMatchWeighter.applyAsInt(a, b)));
            }
            case LONG: {
                ToLongBiFunction longMatchWeighter = (ToLongBiFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, variables[0], variables[1]).execute((Block4 & Serializable)(drools, scoreHolder, a, b) -> AbstractBiConstraintConsequence.impactScore(constraint, drools, scoreHolder, longMatchWeighter.applyAsLong(a, b)));
            }
            case BIG_DECIMAL: {
                BiFunction bigDecimalMatchWeighter = (BiFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, variables[0], variables[1]).execute((Block4 & Serializable)(drools, scoreHolder, a, b) -> AbstractBiConstraintConsequence.impactScore(constraint, drools, scoreHolder, (BigDecimal)bigDecimalMatchWeighter.apply(a, b)));
            }
            case DEFAULT: {
                return DSL.on(scoreHolderGlobal).execute(AbstractConstraintConsequence::impactScore);
            }
        }
        throw new UnsupportedOperationException(consequence.getMatchWeightType().toString());
    }
}

