/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonListInverseVariableDemand;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;

public class UnassignedValueSelector<Solution_>
extends AbstractValueSelector<Solution_>
implements EntityIndependentValueSelector<Solution_> {
    protected final EntityIndependentValueSelector<Solution_> childValueSelector;
    protected SingletonInverseVariableSupply inverseVariableSupply;

    public UnassignedValueSelector(EntityIndependentValueSelector<Solution_> childValueSelector) {
        if (childValueSelector.isNeverEnding()) {
            throw new IllegalArgumentException("The selector (" + this + ") has a childValueSelector (" + childValueSelector + ") with neverEnding (" + childValueSelector.isNeverEnding() + ").\nThis is not allowed because " + UnassignedValueSelector.class.getSimpleName() + " cannot decorate a never-ending child value selector.\nThis could be a result of using random selection order (which is often the default).");
        }
        this.childValueSelector = childValueSelector;
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        ListVariableDescriptor variableDescriptor = (ListVariableDescriptor)this.childValueSelector.getVariableDescriptor();
        this.inverseVariableSupply = phaseScope.getScoreDirector().getSupplyManager().demand(new SingletonListInverseVariableDemand(variableDescriptor));
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.inverseVariableSupply = null;
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public long getSize(Object entity) {
        return this.getSize();
    }

    @Override
    public long getSize() {
        return this.streamUnassignedValues().count();
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return this.iterator();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.streamUnassignedValues().iterator();
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return this.iterator();
    }

    private Stream<Object> streamUnassignedValues() {
        return StreamSupport.stream(Spliterators.spliterator(this.childValueSelector.iterator(), this.childValueSelector.getSize(), 0), false).filter(value -> this.inverseVariableSupply.getInverseSingleton(value) == null);
    }

    public String toString() {
        return "Unassigned(" + this.childValueSelector + ")";
    }
}

