/*
 * Decompiled with CFR 0.152.
 */
package org.acme.employeescheduling.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Transient;
import org.acme.employeescheduling.domain.Shift;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;

@Entity
public class ScheduleState
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    @Id
    Long tenantId;
    Integer publishLength;
    Integer draftLength;
    LocalDate firstDraftDate;
    LocalDate lastHistoricDate;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    @JsonIgnore
    public boolean isHistoric(LocalDateTime dateTime) {
        return dateTime.isBefore(this.getFirstPublishedDate().atTime(LocalTime.MIDNIGHT));
    }

    @JsonIgnore
    public boolean isDraft(LocalDateTime dateTime) {
        return !dateTime.isBefore(this.getFirstDraftDate().atTime(LocalTime.MIDNIGHT));
    }

    @JsonIgnore
    public boolean isPublished(LocalDateTime dateTime) {
        return !this.isHistoric(dateTime) && !this.isDraft(dateTime);
    }

    @JsonIgnore
    public boolean isHistoric(Shift shift) {
        return this.isHistoric(shift.getStart());
    }

    @JsonIgnore
    public boolean isDraft(Shift shift) {
        return this.isDraft(shift.getStart());
    }

    @JsonIgnore
    public boolean isPublished(Shift shift) {
        return this.isPublished(shift.getStart());
    }

    @JsonIgnore
    public LocalDate getFirstPublishedDate() {
        return this.$$_hibernate_read_lastHistoricDate().plusDays(1L);
    }

    public LocalDate getFirstUnplannedDate() {
        return this.$$_hibernate_read_firstDraftDate().plusDays(this.$$_hibernate_read_draftLength().intValue());
    }

    public Long getTenantId() {
        return this.$$_hibernate_read_tenantId();
    }

    public void setTenantId(Long tenantId) {
        this.$$_hibernate_write_tenantId(tenantId);
    }

    public Integer getPublishLength() {
        return this.$$_hibernate_read_publishLength();
    }

    public void setPublishLength(Integer publishNotice) {
        this.$$_hibernate_write_publishLength(publishNotice);
    }

    public Integer getDraftLength() {
        return this.$$_hibernate_read_draftLength();
    }

    public void setDraftLength(Integer draftLength) {
        this.$$_hibernate_write_draftLength(draftLength);
    }

    public LocalDate getFirstDraftDate() {
        return this.$$_hibernate_read_firstDraftDate();
    }

    public void setFirstDraftDate(LocalDate firstDraftDate) {
        this.$$_hibernate_write_firstDraftDate(firstDraftDate);
    }

    public LocalDate getLastHistoricDate() {
        return this.$$_hibernate_read_lastHistoricDate();
    }

    public void setLastHistoricDate(LocalDate lastHistoricDate) {
        this.$$_hibernate_write_lastHistoricDate(lastHistoricDate);
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        ScheduleState scheduleState = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        ScheduleState scheduleState = this;
        scheduleState = null;
        scheduleState = NoopCollectionTracker.INSTANCE;
        return scheduleState;
    }

    public Long $$_hibernate_read_tenantId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.tenantId = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "tenantId", (Object)this.tenantId);
        }
        return this.tenantId;
    }

    public void $$_hibernate_write_tenantId(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.tenantId = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "tenantId", (Object)this.tenantId, (Object)l);
            return;
        }
        this.tenantId = l;
    }

    public Integer $$_hibernate_read_publishLength() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.publishLength = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "publishLength", (Object)this.publishLength);
        }
        return this.publishLength;
    }

    public void $$_hibernate_write_publishLength(Integer n) {
        if (!Objects.deepEquals(n, this.publishLength)) {
            this.$$_hibernate_trackChange("publishLength");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.publishLength = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "publishLength", (Object)this.publishLength, (Object)n);
            return;
        }
        this.publishLength = n;
    }

    public Integer $$_hibernate_read_draftLength() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.draftLength = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "draftLength", (Object)this.draftLength);
        }
        return this.draftLength;
    }

    public void $$_hibernate_write_draftLength(Integer n) {
        if (!Objects.deepEquals(n, this.draftLength)) {
            this.$$_hibernate_trackChange("draftLength");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.draftLength = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "draftLength", (Object)this.draftLength, (Object)n);
            return;
        }
        this.draftLength = n;
    }

    public LocalDate $$_hibernate_read_firstDraftDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.firstDraftDate = (LocalDate)this.$$_hibernate_getInterceptor().readObject((Object)this, "firstDraftDate", (Object)this.firstDraftDate);
        }
        return this.firstDraftDate;
    }

    public void $$_hibernate_write_firstDraftDate(LocalDate localDate) {
        if (!Objects.deepEquals(localDate, this.firstDraftDate)) {
            this.$$_hibernate_trackChange("firstDraftDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.firstDraftDate = (LocalDate)this.$$_hibernate_getInterceptor().writeObject((Object)this, "firstDraftDate", (Object)this.firstDraftDate, (Object)localDate);
            return;
        }
        this.firstDraftDate = localDate;
    }

    public LocalDate $$_hibernate_read_lastHistoricDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastHistoricDate = (LocalDate)this.$$_hibernate_getInterceptor().readObject((Object)this, "lastHistoricDate", (Object)this.lastHistoricDate);
        }
        return this.lastHistoricDate;
    }

    public void $$_hibernate_write_lastHistoricDate(LocalDate localDate) {
        if (!Objects.deepEquals(localDate, this.lastHistoricDate)) {
            this.$$_hibernate_trackChange("lastHistoricDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastHistoricDate = (LocalDate)this.$$_hibernate_getInterceptor().writeObject((Object)this, "lastHistoricDate", (Object)this.lastHistoricDate, (Object)localDate);
            return;
        }
        this.lastHistoricDate = localDate;
    }
}

