/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.descriptor;

import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableGraphType;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;

public class BasicVariableDescriptor<Solution_>
extends GenuineVariableDescriptor<Solution_> {
    private boolean chained;
    private boolean nullable;

    public BasicVariableDescriptor(EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(entityDescriptor, variableMemberAccessor);
    }

    @Override
    protected void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningVariable planningVariableAnnotation = this.variableMemberAccessor.getAnnotation(PlanningVariable.class);
        this.processNullable(descriptorPolicy, planningVariableAnnotation);
        this.processChained(descriptorPolicy, planningVariableAnnotation);
        this.processValueRangeRefs(descriptorPolicy, planningVariableAnnotation.valueRangeProviderRefs());
        this.processStrength(descriptorPolicy, planningVariableAnnotation.strengthComparatorClass(), planningVariableAnnotation.strengthWeightFactoryClass());
    }

    private void processNullable(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        this.nullable = planningVariableAnnotation.nullable();
        if (this.nullable && this.variableMemberAccessor.getType().isPrimitive()) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with nullable (" + this.nullable + "), which is not compatible with the primitive propertyType (" + this.variableMemberAccessor.getType() + ").");
        }
    }

    private void processChained(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        boolean bl = this.chained = planningVariableAnnotation.graphType() == PlanningVariableGraphType.CHAINED;
        if (!this.chained) {
            return;
        }
        if (!this.acceptsValueType(this.entityDescriptor.getEntityClass())) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with chained (" + this.chained + ") and propertyType (" + this.getVariablePropertyType() + ") which is not a superclass/interface of or the same as the entityClass (" + this.entityDescriptor.getEntityClass() + ").\nIf an entity's chained planning variable cannot point to another entity of the same class, then it is impossible to make a chain longer than 1 entity and therefore chaining is useless.");
        }
        if (this.nullable) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with chained (" + this.chained + "), which is not compatible with nullable (" + this.nullable + ").");
        }
    }

    @Override
    public boolean isListVariable() {
        return false;
    }

    @Override
    public boolean isChained() {
        return this.chained;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean acceptsValueType(Class<?> valueType) {
        return this.getVariablePropertyType().isAssignableFrom(valueType);
    }

    @Override
    public boolean isInitialized(Object entity) {
        if (this.isNullable()) {
            return true;
        }
        Object variable = this.getValue(entity);
        return variable != null;
    }
}

