/*
 * Decompiled with CFR 0.152.
 */
package org.acme.facilitylocation.domain;

import org.acme.facilitylocation.domain.Facility;
import org.acme.facilitylocation.domain.Location;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity
public class Consumer {
    private long id;
    private Location location;
    private long demand;
    @PlanningVariable(valueRangeProviderRefs={"facilityRange"})
    private Facility facility;

    public Consumer() {
    }

    public Consumer(long id, Location location, long demand) {
        this.id = id;
        this.location = location;
        this.demand = demand;
    }

    public boolean isAssigned() {
        return this.facility != null;
    }

    public long distanceFromFacility() {
        if (this.facility == null) {
            throw new IllegalStateException("No facility is assigned.");
        }
        return this.facility.getLocation().getDistanceTo(this.location);
    }

    public long getId() {
        return this.id;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public long getDemand() {
        return this.demand;
    }

    public void setDemand(long demand) {
        this.demand = demand;
    }

    public Facility getFacility() {
        return this.facility;
    }

    public void setFacility(Facility facility) {
        this.facility = facility;
    }

    public String toString() {
        return "Consumer " + this.id + " (" + this.demand + " dem)";
    }

    public Facility $get$optaplanner$__field$__facility() {
        return this.facility;
    }

    public void $set$optaplanner$__field$__facility(Facility facility) {
        this.facility = facility;
    }

    public long $get$optaplanner$__field$__id() {
        return this.id;
    }

    public void $set$optaplanner$__field$__id(long l) {
        this.id = l;
    }

    public Location $get$optaplanner$__field$__location() {
        return this.location;
    }

    public void $set$optaplanner$__field$__location(Location location) {
        this.location = location;
    }

    public long $get$optaplanner$__field$__demand() {
        return this.demand;
    }

    public void $set$optaplanner$__field$__demand(long l) {
        this.demand = l;
    }
}

