/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quickstarts.all.rest;

import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Observes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.optaplanner.quickstarts.all.domain.QuickstartMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="quickstart")
public class QuickstartLauncherResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuickstartLauncherResource.class);
    @ConfigProperty(name="startup-open-browser", defaultValue="false")
    boolean startupOpenBrowser;
    @ConfigProperty(name="quarkus.http.port")
    int httpPort;
    private List<QuickstartMeta> quickstartMetaList;
    private boolean development;
    private int nextPort = 8081;
    private java.nio.file.Path baseDirectory;
    private Map<Integer, Process> portToProcessMap;

    public void setup(@Observes StartupEvent startupEvent) {
        this.quickstartMetaList = Arrays.asList(new QuickstartMeta("school-timetabling"), new QuickstartMeta("facility-location"), new QuickstartMeta("maintenance-scheduling"), new QuickstartMeta("vaccination-scheduling"), new QuickstartMeta("call-center"), new QuickstartMeta("vehicle-routing"), new QuickstartMeta("order-picking"), new QuickstartMeta("employee-scheduling"));
        java.nio.file.Path workingDirectory = Paths.get("", new String[0]).toAbsolutePath();
        if (Files.exists(workingDirectory.resolve("target"), new LinkOption[0])) {
            this.baseDirectory = workingDirectory.getParent().getParent();
            this.development = true;
        } else {
            this.baseDirectory = workingDirectory.resolve(Paths.get("quickstarts", "binaries"));
            this.development = false;
        }
        this.portToProcessMap = new HashMap<Integer, Process>(this.quickstartMetaList.size());
        this.baseDirectory = this.baseDirectory.toAbsolutePath();
        if (this.startupOpenBrowser) {
            this.openInBrowser(this.httpPort);
        }
    }

    public void shutdown(@Observes ShutdownEvent shutdownEvent) {
        for (QuickstartMeta quickstartMeta : this.quickstartMetaList) {
            for (int port : quickstartMeta.getPorts()) {
                this.portToProcessMap.remove(port).destroy();
            }
            quickstartMeta.getPorts().clear();
        }
    }

    @GET
    public List<QuickstartMeta> getQuickstartMetaList() {
        return this.quickstartMetaList;
    }

    @Path(value="{quickstartId}/launch")
    @POST
    public void launchQuickstart(@PathParam(value="quickstartId") String quickstartId) {
        Process process;
        ProcessBuilder processBuilder;
        QuickstartMeta quickstartMeta = this.quickstartMetaList.stream().filter(quickstartMeta_ -> quickstartMeta_.getId().equals(quickstartId)).findFirst().orElseThrow(() -> new IllegalArgumentException("The quickstartId (" + quickstartId + ") doesn't exist."));
        LOGGER.info("Starting quickstart ({})...", (Object)quickstartId);
        int port = this.nextPort++;
        String portArg = "-Dquarkus.http.port=" + port;
        String corsArg = "-Dquarkus.http.cors=true";
        if (this.development) {
            String mvnCommand = System.getProperty("os.name").startsWith("Windows") ? this.baseDirectory.resolve(Paths.get("build", "mvnw.cmd")).toString() : this.baseDirectory.resolve(Paths.get("build", "mvnw")).toString();
            processBuilder = new ProcessBuilder(mvnCommand, "-f", "../use-cases/" + quickstartId, "quarkus:dev", portArg, corsArg, "-Ddebug=false");
            processBuilder.directory(this.baseDirectory.resolve("build").toFile());
        } else {
            processBuilder = new ProcessBuilder("java", portArg, corsArg, "-jar", this.getQuickstartRunnerJar(quickstartId).getAbsolutePath());
            processBuilder.directory(this.baseDirectory.resolve(Paths.get("use-cases", quickstartId)).toFile());
        }
        processBuilder.inheritIO();
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed starting the subprocess for quickstart (" + quickstartId + ").\n" + (this.development ? "Maybe check if \"build/mvnw\" and \"build\\mvnw.cmd\" exist." : "Maybe install Java and check if \"java --version\" works."), e);
        }
        this.portToProcessMap.put(port, process);
        quickstartMeta.getPorts().add(port);
    }

    private File getQuickstartRunnerJar(String quickstartId) {
        File quickstartRunnerJar = this.baseDirectory.resolve(Paths.get("use-cases", quickstartId, "quarkus-app", "quarkus-run.jar")).toFile();
        if (!quickstartRunnerJar.exists()) {
            throw new IllegalStateException("The quickstart (" + quickstartId + ") runner JAR file does not exist (" + quickstartRunnerJar.getAbsolutePath() + ").");
        }
        return quickstartRunnerJar;
    }

    @Path(value="{quickstartId}/stop/{port}")
    @DELETE
    public void stopQuickstart(@PathParam(value="quickstartId") String quickstartId, @PathParam(value="port") int port) {
        QuickstartMeta quickstartMeta = this.quickstartMetaList.stream().filter(quickstartMeta_ -> quickstartMeta_.getPorts().contains(port)).findFirst().orElseThrow(() -> new IllegalArgumentException("The process on port (" + port + ") was already destroyed or never existed."));
        if (!quickstartMeta.getId().equals(quickstartId)) {
            throw new IllegalArgumentException("The quickstartId (" + quickstartId + ") does not match the quickstart (" + quickstartMeta.getId() + ") on port (" + port + ").");
        }
        quickstartMeta.getPorts().remove((Object)port);
        Process process = this.portToProcessMap.remove(port);
        process.destroy();
    }

    private void openInBrowser(int port) {
        Desktop desktop;
        String url = "http://localhost:" + port;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop == null || !desktop.isSupported(Desktop.Action.BROWSE)) {
            LOGGER.warn("There is no default browser to show the URL (" + url + ").");
            return;
        }
        try {
            desktop.browse(new URI(url));
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException("Failed opening the default browser to show the URL (" + url + ").", e);
        }
    }
}

