/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.quad;

import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.common.Group;
import org.optaplanner.constraint.streams.bavet.quad.AbstractGroupQuadNode;
import org.optaplanner.constraint.streams.bavet.quad.QuadTuple;
import org.optaplanner.constraint.streams.bavet.tri.TriTuple;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.impl.util.Triple;

final class Group3Mapping0CollectorQuadNode<OldA, OldB, OldC, OldD, A, B, C>
extends AbstractGroupQuadNode<OldA, OldB, OldC, OldD, TriTuple<A, B, C>, Triple<A, B, C>, Void, Void> {
    private final QuadFunction<OldA, OldB, OldC, OldD, A> groupKeyMappingA;
    private final QuadFunction<OldA, OldB, OldC, OldD, B> groupKeyMappingB;
    private final QuadFunction<OldA, OldB, OldC, OldD, C> groupKeyMappingC;
    private final int outputStoreSize;

    public Group3Mapping0CollectorQuadNode(QuadFunction<OldA, OldB, OldC, OldD, A> groupKeyMappingA, QuadFunction<OldA, OldB, OldC, OldD, B> groupKeyMappingB, QuadFunction<OldA, OldB, OldC, OldD, C> groupKeyMappingC, int groupStoreIndex, Consumer<TriTuple<A, B, C>> nextNodesInsert, Consumer<TriTuple<A, B, C>> nextNodesRetract, int outputStoreSize) {
        super(groupStoreIndex, null, nextNodesInsert, nextNodesRetract);
        this.groupKeyMappingA = groupKeyMappingA;
        this.groupKeyMappingB = groupKeyMappingB;
        this.groupKeyMappingC = groupKeyMappingC;
        this.outputStoreSize = outputStoreSize;
    }

    @Override
    protected Triple<A, B, C> createGroupKey(QuadTuple<OldA, OldB, OldC, OldD> tuple) {
        Object oldA = tuple.factA;
        Object oldB = tuple.factB;
        Object oldC = tuple.factC;
        Object oldD = tuple.factD;
        Object a = this.groupKeyMappingA.apply(oldA, oldB, oldC, oldD);
        Object b = this.groupKeyMappingB.apply(oldA, oldB, oldC, oldD);
        Object c = this.groupKeyMappingC.apply(oldA, oldB, oldC, oldD);
        return Triple.of((Object)a, (Object)b, (Object)c);
    }

    @Override
    protected TriTuple<A, B, C> createOutTuple(Group<TriTuple<A, B, C>, Triple<A, B, C>, Void> group) {
        Triple key = (Triple)group.groupKey;
        return new TriTuple<Object, Object, Object>(key.getA(), key.getB(), key.getC(), this.outputStoreSize);
    }

    public String toString() {
        return "GroupQuadNode 3+0";
    }
}

