/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score.stream;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactory;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactoryService;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactoryService;
import org.optaplanner.core.impl.score.director.ScoreDirectorType;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;
import org.optaplanner.test.impl.score.stream.DefaultMultiConstraintVerification;
import org.optaplanner.test.impl.score.stream.DefaultSingleConstraintVerification;

public final class DefaultConstraintVerifier<ConstraintProvider_ extends ConstraintProvider, Solution_, Score_ extends Score<Score_>>
implements ConstraintVerifier<ConstraintProvider_, Solution_> {
    private final ServiceLoader<ScoreDirectorFactoryService> serviceLoader = ServiceLoader.load(ScoreDirectorFactoryService.class);
    private final ConstraintProvider_ constraintProvider;
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private ConstraintStreamImplType constraintStreamImplType;
    private Boolean droolsAlphaNetworkCompilationEnabled;

    public DefaultConstraintVerifier(ConstraintProvider_ constraintProvider, SolutionDescriptor<Solution_> solutionDescriptor) {
        this.constraintProvider = constraintProvider;
        this.solutionDescriptor = solutionDescriptor;
    }

    public ConstraintStreamImplType getConstraintStreamImplType() {
        return Objects.requireNonNullElse(this.constraintStreamImplType, ConstraintStreamImplType.DROOLS);
    }

    @Override
    public ConstraintVerifier<ConstraintProvider_, Solution_> withConstraintStreamImplType(ConstraintStreamImplType constraintStreamImplType) {
        Objects.requireNonNull(constraintStreamImplType);
        this.constraintStreamImplType = constraintStreamImplType;
        return this;
    }

    public boolean isDroolsAlphaNetworkCompilationEnabled() {
        return Objects.requireNonNullElse(this.droolsAlphaNetworkCompilationEnabled, !ConfigUtils.isNativeImage());
    }

    @Override
    public ConstraintVerifier<ConstraintProvider_, Solution_> withDroolsAlphaNetworkCompilationEnabled(boolean droolsAlphaNetworkCompilationEnabled) {
        this.droolsAlphaNetworkCompilationEnabled = droolsAlphaNetworkCompilationEnabled;
        return this;
    }

    public DefaultSingleConstraintVerification<Solution_, Score_> verifyThat(BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> constraintFunction) {
        Objects.requireNonNull(constraintFunction);
        AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory = this.createScoreDirectorFactory(constraintFunction);
        return new DefaultSingleConstraintVerification<Solution_, Score_>(scoreDirectorFactory);
    }

    private AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> createScoreDirectorFactory(BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> constraintFunction) {
        ConstraintProvider actualConstraintProvider = constraintFactory -> new Constraint[]{(Constraint)constraintFunction.apply(this.constraintProvider, constraintFactory)};
        return this.createScoreDirectorFactory(actualConstraintProvider);
    }

    private AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> createScoreDirectorFactory(ConstraintProvider constraintProvider) {
        boolean isDroolsAlphaNetworkCompilationEnabled = this.droolsAlphaNetworkCompilationEnabled == null ? this.getConstraintStreamImplType() != ConstraintStreamImplType.BAVET : this.droolsAlphaNetworkCompilationEnabled;
        return this.serviceLoader.stream().map(ServiceLoader.Provider::get).filter(s -> s.getSupportedScoreDirectorType() == ScoreDirectorType.CONSTRAINT_STREAMS).map(s -> (AbstractConstraintStreamScoreDirectorFactoryService)s).filter(s -> s.supportsImplType(this.getConstraintStreamImplType())).map(s -> s.buildScoreDirectorFactory(this.solutionDescriptor, constraintProvider, isDroolsAlphaNetworkCompilationEnabled)).filter(Objects::nonNull).findFirst().orElseThrow(() -> {
            String expectedModule = this.getConstraintStreamImplType() == ConstraintStreamImplType.BAVET ? "optaplanner-constraint-streams-bavet" : "optaplanner-constraint-streams-drools";
            throw new IllegalStateException("Constraint Streams implementation was not found on the classpath.\nMaybe include org.optaplanner:" + expectedModule + " dependency in your project?\nMaybe ensure your uberjar bundles META-INF/services from included JAR files?");
        });
    }

    public DefaultMultiConstraintVerification<Solution_, Score_> verifyThat() {
        AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory = this.createScoreDirectorFactory((ConstraintProvider)this.constraintProvider);
        return new DefaultMultiConstraintVerification<Solution_, Score_>(scoreDirectorFactory, (ConstraintProvider)this.constraintProvider);
    }
}

