/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vehiclerouting.bootstrap;

import java.util.List;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.acme.vehiclerouting.domain.Customer;
import org.acme.vehiclerouting.domain.Depot;
import org.acme.vehiclerouting.domain.Location;
import org.acme.vehiclerouting.domain.Vehicle;
import org.acme.vehiclerouting.domain.VehicleRoutingSolution;
import org.acme.vehiclerouting.domain.geo.DistanceCalculator;
import org.acme.vehiclerouting.domain.geo.EuclideanDistanceCalculator;

public class DemoDataBuilder {
    private static final AtomicLong sequence = new AtomicLong();
    private final DistanceCalculator distanceCalculator = new EuclideanDistanceCalculator();
    private Location southWestCorner;
    private Location northEastCorner;
    private int customerCount;
    private int vehicleCount;
    private int depotCount;
    private int minDemand;
    private int maxDemand;
    private int vehicleCapacity;

    private DemoDataBuilder() {
    }

    public static DemoDataBuilder builder() {
        return new DemoDataBuilder();
    }

    public DemoDataBuilder setSouthWestCorner(Location southWestCorner) {
        this.southWestCorner = southWestCorner;
        return this;
    }

    public DemoDataBuilder setNorthEastCorner(Location northEastCorner) {
        this.northEastCorner = northEastCorner;
        return this;
    }

    public DemoDataBuilder setMinDemand(int minDemand) {
        this.minDemand = minDemand;
        return this;
    }

    public DemoDataBuilder setMaxDemand(int maxDemand) {
        this.maxDemand = maxDemand;
        return this;
    }

    public DemoDataBuilder setCustomerCount(int customerCount) {
        this.customerCount = customerCount;
        return this;
    }

    public DemoDataBuilder setVehicleCount(int vehicleCount) {
        this.vehicleCount = vehicleCount;
        return this;
    }

    public DemoDataBuilder setDepotCount(int depotCount) {
        this.depotCount = depotCount;
        return this;
    }

    public DemoDataBuilder setVehicleCapacity(int vehicleCapacity) {
        this.vehicleCapacity = vehicleCapacity;
        return this;
    }

    public VehicleRoutingSolution build() {
        if (this.minDemand < 1) {
            throw new IllegalStateException("minDemand (" + this.minDemand + ") must be greater than zero.");
        }
        if (this.maxDemand < 1) {
            throw new IllegalStateException("maxDemand (" + this.maxDemand + ") must be greater than zero.");
        }
        if (this.minDemand >= this.maxDemand) {
            throw new IllegalStateException("maxDemand (" + this.maxDemand + ") must be greater than minDemand (" + this.minDemand + ").");
        }
        if (this.vehicleCapacity < 1) {
            throw new IllegalStateException("Number of vehicleCapacity (" + this.vehicleCapacity + ") must be greater than zero.");
        }
        if (this.customerCount < 1) {
            throw new IllegalStateException("Number of customerCount (" + this.customerCount + ") must be greater than zero.");
        }
        if (this.vehicleCount < 1) {
            throw new IllegalStateException("Number of vehicleCount (" + this.vehicleCount + ") must be greater than zero.");
        }
        if (this.depotCount < 1) {
            throw new IllegalStateException("Number of depotCount (" + this.depotCount + ") must be greater than zero.");
        }
        if (this.northEastCorner.getLatitude() <= this.southWestCorner.getLatitude()) {
            throw new IllegalStateException("northEastCorner.getLatitude (" + this.northEastCorner.getLatitude() + ") must be greater than southWestCorner.getLatitude(" + this.southWestCorner.getLatitude() + ").");
        }
        if (this.northEastCorner.getLongitude() <= this.southWestCorner.getLongitude()) {
            throw new IllegalStateException("northEastCorner.getLongitude (" + this.northEastCorner.getLongitude() + ") must be greater than southWestCorner.getLongitude(" + this.southWestCorner.getLongitude() + ").");
        }
        String name = "demo";
        Random random = new Random(0L);
        PrimitiveIterator.OfDouble latitudes = random.doubles(this.southWestCorner.getLatitude(), this.northEastCorner.getLatitude()).iterator();
        PrimitiveIterator.OfDouble longitudes = random.doubles(this.southWestCorner.getLongitude(), this.northEastCorner.getLongitude()).iterator();
        PrimitiveIterator.OfInt demand = random.ints(this.minDemand, this.maxDemand + 1).iterator();
        PrimitiveIterator.OfInt depotRandom = random.ints(0, this.depotCount).iterator();
        Supplier<Depot> depotSupplier = () -> new Depot(sequence.incrementAndGet(), new Location(sequence.incrementAndGet(), latitudes.nextDouble(), longitudes.nextDouble()));
        List<Depot> depotList = Stream.generate(depotSupplier).limit(this.depotCount).collect(Collectors.toList());
        Supplier<Vehicle> vehicleSupplier = () -> new Vehicle(sequence.incrementAndGet(), this.vehicleCapacity, (Depot)depotList.get(depotRandom.nextInt()));
        List<Vehicle> vehicleList = Stream.generate(vehicleSupplier).limit(this.vehicleCount).collect(Collectors.toList());
        Supplier<Customer> customerSupplier = () -> new Customer(sequence.incrementAndGet(), new Location(sequence.incrementAndGet(), latitudes.nextDouble(), longitudes.nextDouble()), demand.nextInt());
        List<Customer> customerList = Stream.generate(customerSupplier).limit(this.customerCount).collect(Collectors.toList());
        List<Location> locationList = Stream.concat(customerList.stream().map(Customer::getLocation), depotList.stream().map(Depot::getLocation)).collect(Collectors.toList());
        this.distanceCalculator.initDistanceMaps(locationList);
        return new VehicleRoutingSolution(name, locationList, depotList, vehicleList, customerList, this.southWestCorner, this.northEastCorner);
    }
}

