/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vehiclerouting.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Map;

@JsonFormat(shape=JsonFormat.Shape.ARRAY)
@JsonIgnoreProperties(value={"id"})
public class Location {
    private final long id;
    private final double latitude;
    private final double longitude;
    private Map<Location, Long> distanceMap;

    public Location(long id, double latitude, double longitude) {
        this.id = id;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public long getId() {
        return this.id;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setDistanceMap(Map<Location, Long> distanceMap) {
        this.distanceMap = distanceMap;
    }

    public long getDistanceTo(Location location) {
        return this.distanceMap.get(location);
    }

    public double getAngle(Location location) {
        double latitudeDifference = location.latitude - this.latitude;
        double longitudeDifference = location.longitude - this.longitude;
        return Math.atan2(latitudeDifference, longitudeDifference);
    }
}

