/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vehiclerouting.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.acme.vehiclerouting.domain.Customer;
import org.acme.vehiclerouting.domain.Depot;
import org.acme.vehiclerouting.domain.Location;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningListVariable;

@PlanningEntity
public class Vehicle {
    private long id;
    private int capacity;
    private Depot depot;
    @PlanningListVariable(valueRangeProviderRefs={"customerRange"})
    private List<Customer> customerList;

    public Vehicle() {
    }

    public Vehicle(long id, int capacity, Depot depot) {
        this.id = id;
        this.capacity = capacity;
        this.depot = depot;
        this.customerList = new ArrayList<Customer>();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public Depot getDepot() {
        return this.depot;
    }

    public void setDepot(Depot depot) {
        this.depot = depot;
    }

    public List<Customer> getCustomerList() {
        return this.customerList;
    }

    public void setCustomerList(List<Customer> customerList) {
        this.customerList = customerList;
    }

    public List<Location> getRoute() {
        if (this.customerList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Location> route = new ArrayList<Location>();
        route.add(this.depot.getLocation());
        for (Customer customer : this.customerList) {
            route.add(customer.getLocation());
        }
        route.add(this.depot.getLocation());
        return route;
    }

    public int getTotalDemand() {
        int totalDemand = 0;
        for (Customer customer : this.customerList) {
            totalDemand += customer.getDemand();
        }
        return totalDemand;
    }

    public long getTotalDistanceMeters() {
        if (this.customerList.isEmpty()) {
            return 0L;
        }
        long totalDistance = 0L;
        Location previousLocation = this.depot.getLocation();
        for (Customer customer : this.customerList) {
            totalDistance += previousLocation.getDistanceTo(customer.getLocation());
            previousLocation = customer.getLocation();
        }
        return totalDistance += previousLocation.getDistanceTo(this.depot.getLocation());
    }

    public String toString() {
        return "Vehicle{id=" + this.id + "}";
    }
}

