/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vehiclerouting.domain.geo;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.acme.vehiclerouting.domain.Location;

public interface DistanceCalculator {
    public long calculateDistance(Location var1, Location var2);

    default public Map<Location, Map<Location, Long>> calculateBulkDistance(Collection<Location> fromLocations, Collection<Location> toLocations) {
        return fromLocations.stream().collect(Collectors.toMap(Function.identity(), from -> toLocations.stream().collect(Collectors.toMap(Function.identity(), to -> this.calculateDistance((Location)from, (Location)to)))));
    }

    default public void initDistanceMaps(Collection<Location> locationList) {
        Map<Location, Map<Location, Long>> distanceMatrix = this.calculateBulkDistance(locationList, locationList);
        locationList.forEach(location -> location.setDistanceMap((Map)distanceMatrix.get(location)));
    }
}

