/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vehiclerouting.domain.geo;

import org.acme.vehiclerouting.domain.Location;
import org.acme.vehiclerouting.domain.geo.DistanceCalculator;

public class EuclideanDistanceCalculator
implements DistanceCalculator {
    public static final long METERS_PER_DEGREE = 111000L;

    @Override
    public long calculateDistance(Location from, Location to) {
        if (from.equals(to)) {
            return 0L;
        }
        double latitudeDiff = to.getLatitude() - from.getLatitude();
        double longitudeDiff = to.getLongitude() - from.getLongitude();
        return (long)Math.ceil(Math.sqrt(latitudeDiff * latitudeDiff + longitudeDiff * longitudeDiff) * 111000.0);
    }
}

