/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vehiclerouting.rest;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.acme.vehiclerouting.domain.VehicleRoutingSolution;
import org.acme.vehiclerouting.persistence.VehicleRoutingSolutionRepository;
import org.acme.vehiclerouting.rest.Status;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.solver.SolverManager;

@Path(value="/vrp")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SolverResource {
    private static final long PROBLEM_ID = 0L;
    private final AtomicReference<Throwable> solverError = new AtomicReference();
    private final VehicleRoutingSolutionRepository repository;
    private final SolverManager<VehicleRoutingSolution, Long> solverManager;
    private final ScoreManager<VehicleRoutingSolution, HardSoftLongScore> scoreManager;

    public SolverResource(VehicleRoutingSolutionRepository repository, SolverManager<VehicleRoutingSolution, Long> solverManager, ScoreManager<VehicleRoutingSolution, HardSoftLongScore> scoreManager) {
        this.repository = repository;
        this.solverManager = solverManager;
        this.scoreManager = scoreManager;
    }

    private Status statusFromSolution(VehicleRoutingSolution solution) {
        return new Status(solution, this.scoreManager.explainScore((Object)solution).getSummary(), this.solverManager.getSolverStatus((Object)0L));
    }

    @GET
    @Path(value="status")
    public Status status() {
        Optional.ofNullable(this.solverError.getAndSet(null)).ifPresent(throwable -> {
            throw new RuntimeException("Solver failed", (Throwable)throwable);
        });
        Optional<VehicleRoutingSolution> s1 = this.repository.solution();
        VehicleRoutingSolution s = s1.orElse(VehicleRoutingSolution.empty());
        return this.statusFromSolution(s);
    }

    @POST
    @Path(value="solve")
    public void solve() {
        Optional<VehicleRoutingSolution> maybeSolution = this.repository.solution();
        maybeSolution.ifPresent(vehicleRoutingSolution -> this.solverManager.solveAndListen((Object)0L, id -> vehicleRoutingSolution, this.repository::update, (problemId, throwable) -> this.solverError.set((Throwable)throwable)));
    }

    @POST
    @Path(value="stopSolving")
    public void stopSolving() {
        this.solverManager.terminateEarly((Object)0L);
    }
}

