/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vehiclerouting.solver;

import org.acme.vehiclerouting.domain.Vehicle;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;

public class VehicleRoutingConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory factory) {
        return new Constraint[]{this.vehicleCapacity(factory), this.totalDistance(factory)};
    }

    protected Constraint vehicleCapacity(ConstraintFactory factory) {
        return factory.forEach(Vehicle.class).filter(vehicle -> vehicle.getTotalDemand() > vehicle.getCapacity()).penalizeLong("vehicleCapacity", (Score)HardSoftLongScore.ONE_HARD, vehicle -> vehicle.getTotalDemand() - vehicle.getCapacity());
    }

    protected Constraint totalDistance(ConstraintFactory factory) {
        return factory.forEach(Vehicle.class).penalizeLong("distanceFromPreviousStandstill", (Score)HardSoftLongScore.ONE_SOFT, Vehicle::getTotalDistanceMeters);
    }
}

