/*
 * Decompiled with CFR 0.152.
 */
package org.acme.maintenancescheduling.domain;

import java.time.LocalDate;
import java.util.Objects;
import java.util.Set;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.acme.maintenancescheduling.domain.Crew;
import org.acme.maintenancescheduling.solver.EndDateUpdatingVariableListener;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableReference;

@PlanningEntity
@Entity
public class Job
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    @Id
    @GeneratedValue
    private Long id;
    private String name;
    private int durationInDays;
    private LocalDate readyDate;
    private LocalDate dueDate;
    private LocalDate idealEndDate;
    @ElementCollection(fetch=FetchType.EAGER)
    private Set<String> tagSet;
    @PlanningVariable(valueRangeProviderRefs={"crewRange"})
    @ManyToOne
    private Crew crew;
    @PlanningVariable(valueRangeProviderRefs={"startDateRange"})
    private LocalDate startDate;
    @CustomShadowVariable(variableListenerClass=EndDateUpdatingVariableListener.class, sources={@PlanningVariableReference(variableName="startDate")})
    private LocalDate endDate;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public Job() {
    }

    public Job(String name, int durationInDays, LocalDate readyDate, LocalDate dueDate, LocalDate idealEndDate, Set<String> tagSet) {
        this.$$_hibernate_write_name(name);
        this.$$_hibernate_write_durationInDays(durationInDays);
        this.$$_hibernate_write_readyDate(readyDate);
        this.$$_hibernate_write_dueDate(dueDate);
        this.$$_hibernate_write_idealEndDate(idealEndDate);
        this.$$_hibernate_write_tagSet(tagSet);
    }

    public Job(Long id, String name, int durationInDays, LocalDate readyDate, LocalDate dueDate, LocalDate idealEndDate, Set<String> tagSet, Crew crew, LocalDate startDate) {
        this.$$_hibernate_write_id(id);
        this.$$_hibernate_write_name(name);
        this.$$_hibernate_write_durationInDays(durationInDays);
        this.$$_hibernate_write_readyDate(readyDate);
        this.$$_hibernate_write_dueDate(dueDate);
        this.$$_hibernate_write_idealEndDate(idealEndDate);
        this.$$_hibernate_write_tagSet(tagSet);
        this.$$_hibernate_write_crew(crew);
        this.$$_hibernate_write_startDate(startDate);
        this.$$_hibernate_write_endDate(EndDateUpdatingVariableListener.calculateEndDate((LocalDate)startDate, (int)durationInDays));
    }

    public String toString() {
        return this.$$_hibernate_read_name() + "(" + this.$$_hibernate_read_id() + ")";
    }

    @PlanningId
    public Long getId() {
        return this.$$_hibernate_read_id();
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public int getDurationInDays() {
        return this.$$_hibernate_read_durationInDays();
    }

    public LocalDate getReadyDate() {
        return this.$$_hibernate_read_readyDate();
    }

    public LocalDate getDueDate() {
        return this.$$_hibernate_read_dueDate();
    }

    public LocalDate getIdealEndDate() {
        return this.$$_hibernate_read_idealEndDate();
    }

    public Set<String> getTagSet() {
        return this.$$_hibernate_read_tagSet();
    }

    public Crew getCrew() {
        return this.$$_hibernate_read_crew();
    }

    public void setCrew(Crew crew) {
        this.$$_hibernate_write_crew(crew);
    }

    public LocalDate getStartDate() {
        return this.$$_hibernate_read_startDate();
    }

    public void setStartDate(LocalDate startDate) {
        this.$$_hibernate_write_startDate(startDate);
    }

    public LocalDate getEndDate() {
        return this.$$_hibernate_read_endDate();
    }

    public void setEndDate(LocalDate endDate) {
        this.$$_hibernate_write_endDate(endDate);
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        Job job = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        boolean bl;
        block0: {
            int n;
            block1: {
                Job job = this;
                bl = false;
                if (bl || this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("tagSet");
                if (this.tagSet != null || n == -1) break block1;
                bl = true;
                break block0;
            }
            if (this.tagSet == null || this.tagSet instanceof PersistentCollection && !((PersistentCollection)this.tagSet).wasInitialized() || n == this.tagSet.size()) break block0;
            bl = true;
        }
        return bl;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block0: {
            int n;
            block1: {
                Job job = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                if (this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("tagSet");
                if (this.tagSet != null || n == -1) break block1;
                dirtyTracker.add("tagSet");
                break block0;
            }
            if (this.tagSet == null || this.tagSet instanceof PersistentCollection && !((PersistentCollection)this.tagSet).wasInitialized() || n == this.tagSet.size()) break block0;
            dirtyTracker.add("tagSet");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block3: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            Job job = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("tagSet")) break block3;
            if (this.tagSet == null || this.tagSet instanceof PersistentCollection && !((PersistentCollection)this.tagSet).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("tagSet", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("tagSet", this.tagSet.size());
            }
        }
    }

    public Long $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)l);
            return;
        }
        this.id = l;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!Objects.deepEquals(string, this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public int $$_hibernate_read_durationInDays() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.durationInDays = this.$$_hibernate_getInterceptor().readInt((Object)this, "durationInDays", this.durationInDays);
        }
        return this.durationInDays;
    }

    public void $$_hibernate_write_durationInDays(int n) {
        if (n - this.durationInDays != 0) {
            this.$$_hibernate_trackChange("durationInDays");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.durationInDays = this.$$_hibernate_getInterceptor().writeInt((Object)this, "durationInDays", this.durationInDays, n);
            return;
        }
        this.durationInDays = n;
    }

    public LocalDate $$_hibernate_read_readyDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.readyDate = (LocalDate)this.$$_hibernate_getInterceptor().readObject((Object)this, "readyDate", (Object)this.readyDate);
        }
        return this.readyDate;
    }

    public void $$_hibernate_write_readyDate(LocalDate localDate) {
        if (!Objects.deepEquals(localDate, this.readyDate)) {
            this.$$_hibernate_trackChange("readyDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.readyDate = (LocalDate)this.$$_hibernate_getInterceptor().writeObject((Object)this, "readyDate", (Object)this.readyDate, (Object)localDate);
            return;
        }
        this.readyDate = localDate;
    }

    public LocalDate $$_hibernate_read_dueDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.dueDate = (LocalDate)this.$$_hibernate_getInterceptor().readObject((Object)this, "dueDate", (Object)this.dueDate);
        }
        return this.dueDate;
    }

    public void $$_hibernate_write_dueDate(LocalDate localDate) {
        if (!Objects.deepEquals(localDate, this.dueDate)) {
            this.$$_hibernate_trackChange("dueDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.dueDate = (LocalDate)this.$$_hibernate_getInterceptor().writeObject((Object)this, "dueDate", (Object)this.dueDate, (Object)localDate);
            return;
        }
        this.dueDate = localDate;
    }

    public LocalDate $$_hibernate_read_idealEndDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.idealEndDate = (LocalDate)this.$$_hibernate_getInterceptor().readObject((Object)this, "idealEndDate", (Object)this.idealEndDate);
        }
        return this.idealEndDate;
    }

    public void $$_hibernate_write_idealEndDate(LocalDate localDate) {
        if (!Objects.deepEquals(localDate, this.idealEndDate)) {
            this.$$_hibernate_trackChange("idealEndDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.idealEndDate = (LocalDate)this.$$_hibernate_getInterceptor().writeObject((Object)this, "idealEndDate", (Object)this.idealEndDate, (Object)localDate);
            return;
        }
        this.idealEndDate = localDate;
    }

    public Set $$_hibernate_read_tagSet() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.tagSet = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "tagSet", this.tagSet);
        }
        return this.tagSet;
    }

    public void $$_hibernate_write_tagSet(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.tagSet = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "tagSet", this.tagSet, (Object)set);
            return;
        }
        this.tagSet = set;
    }

    public Crew $$_hibernate_read_crew() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.crew = (Crew)this.$$_hibernate_getInterceptor().readObject((Object)this, "crew", (Object)this.crew);
        }
        return this.crew;
    }

    public void $$_hibernate_write_crew(Crew crew) {
        if (!Objects.deepEquals(crew, this.crew)) {
            this.$$_hibernate_trackChange("crew");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.crew = (Crew)this.$$_hibernate_getInterceptor().writeObject((Object)this, "crew", (Object)this.crew, (Object)crew);
            return;
        }
        this.crew = crew;
    }

    public LocalDate $$_hibernate_read_startDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.startDate = (LocalDate)this.$$_hibernate_getInterceptor().readObject((Object)this, "startDate", (Object)this.startDate);
        }
        return this.startDate;
    }

    public void $$_hibernate_write_startDate(LocalDate localDate) {
        if (!Objects.deepEquals(localDate, this.startDate)) {
            this.$$_hibernate_trackChange("startDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.startDate = (LocalDate)this.$$_hibernate_getInterceptor().writeObject((Object)this, "startDate", (Object)this.startDate, (Object)localDate);
            return;
        }
        this.startDate = localDate;
    }

    public LocalDate $$_hibernate_read_endDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.endDate = (LocalDate)this.$$_hibernate_getInterceptor().readObject((Object)this, "endDate", (Object)this.endDate);
        }
        return this.endDate;
    }

    public void $$_hibernate_write_endDate(LocalDate localDate) {
        if (!Objects.deepEquals(localDate, this.endDate)) {
            this.$$_hibernate_trackChange("endDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.endDate = (LocalDate)this.$$_hibernate_getInterceptor().writeObject((Object)this, "endDate", (Object)this.endDate, (Object)localDate);
            return;
        }
        this.endDate = localDate;
    }

    public Crew $get$optaplanner$__field$__crew() {
        return this.crew;
    }

    public void $set$optaplanner$__field$__crew(Crew crew) {
        this.crew = crew;
    }

    public LocalDate $get$optaplanner$__field$__startDate() {
        return this.startDate;
    }

    public void $set$optaplanner$__field$__startDate(LocalDate localDate) {
        this.startDate = localDate;
    }

    public LocalDate $get$optaplanner$__field$__endDate() {
        return this.endDate;
    }

    public void $set$optaplanner$__field$__endDate(LocalDate localDate) {
        this.endDate = localDate;
    }

    public Long $get$optaplanner$__field$__id() {
        return this.id;
    }

    public void $set$optaplanner$__field$__id(Long l) {
        this.id = l;
    }

    public String $get$optaplanner$__field$__name() {
        return this.name;
    }

    public void $set$optaplanner$__field$__name(String string) {
        this.name = string;
    }

    public int $get$optaplanner$__field$__durationInDays() {
        return this.durationInDays;
    }

    public void $set$optaplanner$__field$__durationInDays(int n) {
        this.durationInDays = n;
    }

    public LocalDate $get$optaplanner$__field$__readyDate() {
        return this.readyDate;
    }

    public void $set$optaplanner$__field$__readyDate(LocalDate localDate) {
        this.readyDate = localDate;
    }

    public LocalDate $get$optaplanner$__field$__dueDate() {
        return this.dueDate;
    }

    public void $set$optaplanner$__field$__dueDate(LocalDate localDate) {
        this.dueDate = localDate;
    }

    public LocalDate $get$optaplanner$__field$__idealEndDate() {
        return this.idealEndDate;
    }

    public void $set$optaplanner$__field$__idealEndDate(LocalDate localDate) {
        this.idealEndDate = localDate;
    }

    public Set $get$optaplanner$__field$__tagSet() {
        return this.tagSet;
    }

    public void $set$optaplanner$__field$__tagSet(Set set) {
        this.tagSet = set;
    }
}

