/*
 * Decompiled with CFR 0.152.
 */
package org.acme.maintenancescheduling.domain;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.acme.maintenancescheduling.domain.Crew;
import org.acme.maintenancescheduling.domain.Job;
import org.acme.maintenancescheduling.domain.WorkCalendar;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.ProblemFactCollectionProperty;
import org.optaplanner.core.api.domain.solution.ProblemFactProperty;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.solver.SolverStatus;

@PlanningSolution
public class MaintenanceSchedule {
    @ProblemFactProperty
    private WorkCalendar workCalendar;
    @ProblemFactCollectionProperty
    @ValueRangeProvider(id="crewRange")
    private List<Crew> crewList;
    @PlanningEntityCollectionProperty
    private List<Job> jobList;
    @PlanningScore
    private HardSoftLongScore score;
    private SolverStatus solverStatus;

    public MaintenanceSchedule() {
    }

    public MaintenanceSchedule(WorkCalendar workCalendar, List<Crew> crewList, List<Job> jobList) {
        this.workCalendar = workCalendar;
        this.crewList = crewList;
        this.jobList = jobList;
    }

    @ValueRangeProvider(id="startDateRange")
    public List<LocalDate> createStartDateList() {
        return this.workCalendar.getFromDate().datesUntil(this.workCalendar.getToDate()).filter(date -> date.getDayOfWeek() != DayOfWeek.SATURDAY && date.getDayOfWeek() != DayOfWeek.SUNDAY).collect(Collectors.toList());
    }

    public WorkCalendar getWorkCalendar() {
        return this.workCalendar;
    }

    public List<Crew> getCrewList() {
        return this.crewList;
    }

    public List<Job> getJobList() {
        return this.jobList;
    }

    public HardSoftLongScore getScore() {
        return this.score;
    }

    public void setScore(HardSoftLongScore score) {
        this.score = score;
    }

    public SolverStatus getSolverStatus() {
        return this.solverStatus;
    }

    public void setSolverStatus(SolverStatus solverStatus) {
        this.solverStatus = solverStatus;
    }

    public List $get$optaplanner$__field$__jobList() {
        return this.jobList;
    }

    public void $set$optaplanner$__field$__jobList(List list) {
        this.jobList = list;
    }

    public HardSoftLongScore $get$optaplanner$__field$__score() {
        return this.score;
    }

    public void $set$optaplanner$__field$__score(HardSoftLongScore hardSoftLongScore) {
        this.score = hardSoftLongScore;
    }

    public List $get$optaplanner$__field$__crewList() {
        return this.crewList;
    }

    public void $set$optaplanner$__field$__crewList(List list) {
        this.crewList = list;
    }

    public WorkCalendar $get$optaplanner$__field$__workCalendar() {
        return this.workCalendar;
    }

    public void $set$optaplanner$__field$__workCalendar(WorkCalendar workCalendar) {
        this.workCalendar = workCalendar;
    }

    public SolverStatus $get$optaplanner$__field$__solverStatus() {
        return this.solverStatus;
    }

    public void $set$optaplanner$__field$__solverStatus(SolverStatus solverStatus) {
        this.solverStatus = solverStatus;
    }
}

