/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vaccinationscheduler.domain.solver;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.acme.vaccinationscheduler.domain.Location;
import org.acme.vaccinationscheduler.domain.Person;
import org.acme.vaccinationscheduler.domain.VaccinationCenter;
import org.acme.vaccinationscheduler.domain.VaccineType;
import org.acme.vaccinationscheduler.domain.solver.VaccinationSlot;
import org.acme.vaccinationscheduler.solver.PersonAssignmentDifficultyComparator;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.entity.PlanningPin;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity(difficultyComparatorClass=PersonAssignmentDifficultyComparator.class)
public class PersonAssignment {
    private Person person;
    private Map<VaccinationCenter, Long> distanceMap;
    private Long nearestVaccinationCenterDistance;
    private VaccinationSlot vaccinationSlot = null;

    public PersonAssignment() {
    }

    public PersonAssignment(Person person, Map<VaccinationCenter, Long> distanceMap) {
        this.person = person;
        this.distanceMap = distanceMap;
        if (distanceMap != null) {
            this.nearestVaccinationCenterDistance = distanceMap.values().stream().mapToLong(Long::valueOf).min().orElse(0L);
        }
    }

    public PersonAssignment(PersonAssignment original) {
        this.person = original.person;
        this.distanceMap = original.distanceMap;
        this.nearestVaccinationCenterDistance = original.nearestVaccinationCenterDistance;
        this.vaccinationSlot = original.vaccinationSlot;
    }

    public PersonAssignment(String id, String name, Location homeLocation, Map<VaccinationCenter, Long> distanceMap, LocalDate birthdate, long priorityRating, VaccinationSlot vaccinationSlot) {
        this(new Person(id, name, homeLocation, birthdate, priorityRating), distanceMap);
        this.vaccinationSlot = vaccinationSlot;
    }

    public PersonAssignment(String id, String name, Location homeLocation, Map<VaccinationCenter, Long> distanceMap, LocalDate birthdate, long priorityRating, int doseNumber, VaccineType requiredVaccineType, VaccineType preferredVaccineType, VaccinationCenter requiredVaccinationCenter, VaccinationCenter preferredVaccinationCenter, LocalDate readyDate, LocalDate idealDate, LocalDate dueDate, VaccinationSlot vaccinationSlot) {
        this(new Person(id, name, homeLocation, birthdate, priorityRating, doseNumber, requiredVaccineType, preferredVaccineType, requiredVaccinationCenter, preferredVaccinationCenter, readyDate, idealDate, dueDate), distanceMap);
        this.vaccinationSlot = vaccinationSlot;
    }

    public long getDistanceTo(VaccinationCenter vaccinationCenter) {
        Long distance = this.distanceMap.get(vaccinationCenter);
        if (distance == null) {
            throw new IllegalStateException("The person (" + this.person + ") is lacking a distance to vaccination center (" + vaccinationCenter + ").");
        }
        return distance;
    }

    public long getRegretDistanceTo(VaccinationCenter vaccinationCenter) {
        long distance = this.getDistanceTo(vaccinationCenter);
        VaccinationCenter requiredVaccinationCenter = this.getRequiredVaccinationCenter();
        if (requiredVaccinationCenter != null && requiredVaccinationCenter == vaccinationCenter) {
            return 0L;
        }
        VaccinationCenter preferedVaccinationCenter = this.getPreferredVaccinationCenter();
        if (preferedVaccinationCenter != null && preferedVaccinationCenter == vaccinationCenter) {
            return 0L;
        }
        return distance - this.nearestVaccinationCenterDistance;
    }

    public long getAgeOnVaccinationDate() {
        if (this.vaccinationSlot == null) {
            return -1L;
        }
        return ChronoUnit.YEARS.between(this.person.getBirthdate(), this.vaccinationSlot.getDate());
    }

    public String toString() {
        return this.person.toString();
    }

    public Person getPerson() {
        return this.person;
    }

    @PlanningId
    public String getId() {
        return this.person.getId();
    }

    public String getName() {
        return this.person.getName();
    }

    public Location getHomeLocation() {
        return this.person.getHomeLocation();
    }

    public LocalDate getBirthdate() {
        return this.person.getBirthdate();
    }

    public long getPriorityRating() {
        return this.person.getPriorityRating();
    }

    public int getDoseNumber() {
        return this.person.getDoseNumber();
    }

    public VaccineType getRequiredVaccineType() {
        return this.person.getRequiredVaccineType();
    }

    public VaccineType getPreferredVaccineType() {
        return this.person.getPreferredVaccineType();
    }

    public VaccinationCenter getRequiredVaccinationCenter() {
        return this.person.getRequiredVaccinationCenter();
    }

    public VaccinationCenter getPreferredVaccinationCenter() {
        return this.person.getPreferredVaccinationCenter();
    }

    public LocalDate getReadyDate() {
        return this.person.getReadyDate();
    }

    public LocalDate getIdealDate() {
        return this.person.getIdealDate();
    }

    public LocalDate getDueDate() {
        return this.person.getDueDate();
    }

    @PlanningPin
    public boolean isPinned() {
        return this.person.isPinned();
    }

    @PlanningVariable(nullable=true, valueRangeProviderRefs={"vaccinationSlotRange"})
    public VaccinationSlot getVaccinationSlot() {
        return this.vaccinationSlot;
    }

    public void setVaccinationSlot(VaccinationSlot vaccinationSlot) {
        this.vaccinationSlot = vaccinationSlot;
    }

    public Person $get$optaplanner$__field$__person() {
        return this.person;
    }

    public void $set$optaplanner$__field$__person(Person person) {
        this.person = person;
    }

    public Map $get$optaplanner$__field$__distanceMap() {
        return this.distanceMap;
    }

    public void $set$optaplanner$__field$__distanceMap(Map map) {
        this.distanceMap = map;
    }

    public Long $get$optaplanner$__field$__nearestVaccinationCenterDistance() {
        return this.nearestVaccinationCenterDistance;
    }

    public void $set$optaplanner$__field$__nearestVaccinationCenterDistance(Long l) {
        this.nearestVaccinationCenterDistance = l;
    }

    public VaccinationSlot $get$optaplanner$__field$__vaccinationSlot() {
        return this.vaccinationSlot;
    }

    public void $set$optaplanner$__field$__vaccinationSlot(VaccinationSlot vaccinationSlot) {
        this.vaccinationSlot = vaccinationSlot;
    }
}

