/*
 * Decompiled with CFR 0.152.
 */
package org.acme.vaccinationscheduler.domain.solver;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import org.acme.vaccinationscheduler.domain.Appointment;
import org.acme.vaccinationscheduler.domain.VaccinationCenter;
import org.acme.vaccinationscheduler.domain.VaccineType;
import org.optaplanner.core.api.domain.lookup.PlanningId;

public class VaccinationSlot {
    @PlanningId
    private Long id;
    private VaccinationCenter vaccinationCenter;
    private LocalDate date;
    private LocalTime startTime;
    private VaccineType vaccineType;
    private List<Appointment> unscheduledAppointmentList;
    private int capacity;

    public VaccinationSlot(Long id, VaccinationCenter vaccinationCenter, LocalDateTime startDateTime, VaccineType vaccineType, List<Appointment> unscheduledAppointmentList, int capacity) {
        this.id = id;
        this.vaccinationCenter = vaccinationCenter;
        this.date = startDateTime.toLocalDate();
        this.startTime = startDateTime.toLocalTime();
        this.vaccineType = vaccineType;
        this.unscheduledAppointmentList = unscheduledAppointmentList;
        this.capacity = capacity;
    }

    public VaccinationSlot(Long id, VaccinationCenter vaccinationCenter, LocalDateTime startDateTime, VaccineType vaccineType, int capacity) {
        this.id = id;
        this.vaccinationCenter = vaccinationCenter;
        this.date = startDateTime == null ? null : startDateTime.toLocalDate();
        this.startTime = startDateTime == null ? null : startDateTime.toLocalTime();
        this.vaccineType = vaccineType;
        this.unscheduledAppointmentList = null;
        this.capacity = capacity;
    }

    public LocalDateTime getStartDateTime() {
        return LocalDateTime.of(this.date, this.startTime);
    }

    public String toString() {
        return this.vaccinationCenter + "@" + this.date + "_" + this.startTime + "/" + this.vaccineType;
    }

    public Long getId() {
        return this.id;
    }

    public VaccinationCenter getVaccinationCenter() {
        return this.vaccinationCenter;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public VaccineType getVaccineType() {
        return this.vaccineType;
    }

    public List<Appointment> getUnscheduledAppointmentList() {
        return this.unscheduledAppointmentList;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public Long $get$optaplanner$__field$__id() {
        return this.id;
    }

    public void $set$optaplanner$__field$__id(Long l) {
        this.id = l;
    }
}

