/*
 * Decompiled with CFR 0.152.
 */
package org.acme.maintenancescheduling.bootstrap;

import io.quarkus.runtime.StartupEvent;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.acme.maintenancescheduling.domain.Crew;
import org.acme.maintenancescheduling.domain.Job;
import org.acme.maintenancescheduling.domain.WorkCalendar;
import org.acme.maintenancescheduling.persistence.CrewRepository;
import org.acme.maintenancescheduling.persistence.JobRepository;
import org.acme.maintenancescheduling.persistence.WorkCalendarRepository;
import org.acme.maintenancescheduling.solver.EndDateUpdatingVariableListener;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class DemoDataGenerator {
    @ConfigProperty(name="schedule.demoData", defaultValue="SMALL")
    public DemoData demoData;
    @Inject
    WorkCalendarRepository workCalendarRepository;
    @Inject
    CrewRepository crewRepository;
    @Inject
    JobRepository jobRepository;

    @Transactional
    public void generateDemoData(@Observes StartupEvent startupEvent) {
        if (this.demoData == DemoData.NONE) {
            return;
        }
        ArrayList<Crew> crewList = new ArrayList<Crew>();
        crewList.add(new Crew("Alpha crew"));
        crewList.add(new Crew("Beta crew"));
        crewList.add(new Crew("Gamma crew"));
        if (this.demoData == DemoData.LARGE) {
            crewList.add(new Crew("Delta crew"));
            crewList.add(new Crew("Epsilon crew"));
        }
        this.crewRepository.persist(crewList);
        LocalDate fromDate = LocalDate.now().with(TemporalAdjusters.next(DayOfWeek.MONDAY));
        int weekListSize = this.demoData == DemoData.LARGE ? 16 : 8;
        LocalDate toDate = fromDate.plusWeeks(weekListSize);
        this.workCalendarRepository.persist(new WorkCalendar(fromDate, toDate));
        int workdayTotal = weekListSize * 5;
        String[] JOB_AREA_NAMES = new String[]{"Downtown", "Uptown", "Park", "Airport", "Bay", "Hill", "Forest", "Station", "Hospital", "Harbor", "Market", "Fort", "Beach", "Garden", "River", "Springs", "Tower", "Mountain"};
        String[] JOB_TARGET_NAMES = new String[]{"Street", "Bridge", "Tunnel", "Highway", "Boulevard", "Avenue", "Square", "Plaza"};
        ArrayList<Job> jobList = new ArrayList<Job>();
        int jobListSize = weekListSize * crewList.size() * 3 / 5;
        int jobAreaTargetLimit = Math.min(JOB_TARGET_NAMES.length, crewList.size() * 2);
        Random random = new Random(17L);
        for (int i = 0; i < jobListSize; ++i) {
            String jobArea = JOB_AREA_NAMES[i / jobAreaTargetLimit];
            String jobTarget = JOB_TARGET_NAMES[i % jobAreaTargetLimit];
            int durationInDays = 1 + random.nextInt(10);
            int readyDueBetweenWorkdays = durationInDays + 5 + random.nextInt(workdayTotal - (durationInDays + 5));
            int readyWorkdayOffset = random.nextInt(workdayTotal - readyDueBetweenWorkdays + 1);
            int readyIdealEndBetweenWorkdays = readyDueBetweenWorkdays - 1 - random.nextInt(4);
            LocalDate readyDate = EndDateUpdatingVariableListener.calculateEndDate(fromDate, readyWorkdayOffset);
            LocalDate dueDate = EndDateUpdatingVariableListener.calculateEndDate(readyDate, readyDueBetweenWorkdays);
            LocalDate idealEndDate = EndDateUpdatingVariableListener.calculateEndDate(readyDate, readyIdealEndBetweenWorkdays);
            Set<String> tagSet = random.nextDouble() < 0.1 ? Set.of(jobArea, "Subway") : Set.of(jobArea);
            jobList.add(new Job(jobArea + " " + jobTarget, durationInDays, readyDate, dueDate, idealEndDate, tagSet));
        }
        this.jobRepository.persist(jobList);
    }

    public static enum DemoData {
        NONE,
        SMALL,
        LARGE;

    }
}

