/*
 * Decompiled with CFR 0.152.
 */
package org.acme.maintenancescheduling.domain;

import java.time.LocalDate;
import java.util.Set;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import org.acme.maintenancescheduling.domain.Crew;
import org.acme.maintenancescheduling.solver.EndDateUpdatingVariableListener;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableReference;

@PlanningEntity
@Entity
public class Job {
    @Id
    @GeneratedValue
    private Long id;
    private String name;
    private int durationInDays;
    private LocalDate readyDate;
    private LocalDate dueDate;
    private LocalDate idealEndDate;
    @ElementCollection(fetch=FetchType.EAGER)
    private Set<String> tagSet;
    @PlanningVariable(valueRangeProviderRefs={"crewRange"})
    @ManyToOne
    private Crew crew;
    @PlanningVariable(valueRangeProviderRefs={"startDateRange"})
    private LocalDate startDate;
    @CustomShadowVariable(variableListenerClass=EndDateUpdatingVariableListener.class, sources={@PlanningVariableReference(variableName="startDate")})
    private LocalDate endDate;

    public Job() {
    }

    public Job(String name, int durationInDays, LocalDate readyDate, LocalDate dueDate, LocalDate idealEndDate, Set<String> tagSet) {
        this.name = name;
        this.durationInDays = durationInDays;
        this.readyDate = readyDate;
        this.dueDate = dueDate;
        this.idealEndDate = idealEndDate;
        this.tagSet = tagSet;
    }

    public Job(Long id, String name, int durationInDays, LocalDate readyDate, LocalDate dueDate, LocalDate idealEndDate, Set<String> tagSet, Crew crew, LocalDate startDate) {
        this.id = id;
        this.name = name;
        this.durationInDays = durationInDays;
        this.readyDate = readyDate;
        this.dueDate = dueDate;
        this.idealEndDate = idealEndDate;
        this.tagSet = tagSet;
        this.crew = crew;
        this.startDate = startDate;
        this.endDate = EndDateUpdatingVariableListener.calculateEndDate(startDate, durationInDays);
    }

    public String toString() {
        return this.name + "(" + this.id + ")";
    }

    @PlanningId
    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getDurationInDays() {
        return this.durationInDays;
    }

    public LocalDate getReadyDate() {
        return this.readyDate;
    }

    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public LocalDate getIdealEndDate() {
        return this.idealEndDate;
    }

    public Set<String> getTagSet() {
        return this.tagSet;
    }

    public Crew getCrew() {
        return this.crew;
    }

    public void setCrew(Crew crew) {
        this.crew = crew;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }
}

