/*
 * Decompiled with CFR 0.152.
 */
package org.acme.maintenancescheduling.rest;

import io.quarkus.panache.common.Sort;
import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.acme.maintenancescheduling.domain.Job;
import org.acme.maintenancescheduling.domain.MaintenanceSchedule;
import org.acme.maintenancescheduling.domain.WorkCalendar;
import org.acme.maintenancescheduling.persistence.CrewRepository;
import org.acme.maintenancescheduling.persistence.JobRepository;
import org.acme.maintenancescheduling.persistence.WorkCalendarRepository;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.api.solver.SolverStatus;

@Path(value="/schedule")
public class MaintenanceScheduleResource {
    public static final Long SINGLETON_SCHEDULE_ID = 1L;
    @Inject
    WorkCalendarRepository workCalendarRepository;
    @Inject
    CrewRepository crewRepository;
    @Inject
    JobRepository jobRepository;
    @Inject
    SolverManager<MaintenanceSchedule, Long> solverManager;
    @Inject
    ScoreManager<MaintenanceSchedule, HardSoftScore> scoreManager;

    @GET
    public MaintenanceSchedule getSchedule() {
        SolverStatus solverStatus = this.getSolverStatus();
        MaintenanceSchedule solution = this.findById(SINGLETON_SCHEDULE_ID);
        this.scoreManager.updateScore((Object)solution);
        solution.setSolverStatus(solverStatus);
        return solution;
    }

    public SolverStatus getSolverStatus() {
        return this.solverManager.getSolverStatus((Object)SINGLETON_SCHEDULE_ID);
    }

    @POST
    @Path(value="solve")
    public void solve() {
        this.solverManager.solveAndListen((Object)SINGLETON_SCHEDULE_ID, this::findById, this::save);
    }

    @POST
    @Path(value="stopSolving")
    public void stopSolving() {
        this.solverManager.terminateEarly((Object)SINGLETON_SCHEDULE_ID);
    }

    @Transactional
    protected MaintenanceSchedule findById(Long id) {
        if (!SINGLETON_SCHEDULE_ID.equals(id)) {
            throw new IllegalStateException("There is no schedule with id (" + id + ").");
        }
        return new MaintenanceSchedule((WorkCalendar)this.workCalendarRepository.listAll().get(0), this.crewRepository.listAll(Sort.by((String)"name").and("id")), this.jobRepository.listAll(Sort.by((String)"dueDate").and("readyDate").and("name").and("id")));
    }

    @Transactional
    protected void save(MaintenanceSchedule schedule) {
        for (Job job : schedule.getJobList()) {
            Job attachedJob = (Job)this.jobRepository.findById(job.getId());
            attachedJob.setCrew(job.getCrew());
            attachedJob.setStartDate(job.getStartDate());
            attachedJob.setEndDate(job.getEndDate());
        }
    }
}

