/*
 * Decompiled with CFR 0.152.
 */
package org.acme.maintenancescheduling.solver;

import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashSet;
import org.acme.maintenancescheduling.domain.Job;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;

public class MaintenanceScheduleConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.crewConflict(constraintFactory), this.readyDate(constraintFactory), this.dueDate(constraintFactory), this.beforeIdealEndDate(constraintFactory), this.afterIdealEndDate(constraintFactory), this.tagConflict(constraintFactory)};
    }

    public Constraint crewConflict(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachUniquePair(Job.class, Joiners.equal(Job::getCrew), Joiners.overlapping(Job::getStartDate, Job::getEndDate)).penalizeLong("Crew conflict", (Score)HardSoftLongScore.ONE_HARD, (job1, job2) -> ChronoUnit.DAYS.between(job1.getStartDate().isAfter(job2.getStartDate()) ? job1.getStartDate() : job2.getStartDate(), job1.getEndDate().isBefore(job2.getEndDate()) ? job1.getEndDate() : job2.getEndDate()));
    }

    public Constraint readyDate(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Job.class).filter(job -> job.getReadyDate() != null && job.getStartDate().isBefore(job.getReadyDate())).penalizeLong("Ready date", (Score)HardSoftLongScore.ONE_HARD, job -> ChronoUnit.DAYS.between(job.getStartDate(), job.getReadyDate()));
    }

    public Constraint dueDate(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Job.class).filter(job -> job.getDueDate() != null && job.getEndDate().isAfter(job.getDueDate())).penalizeLong("Due date", (Score)HardSoftLongScore.ONE_HARD, job -> ChronoUnit.DAYS.between(job.getDueDate(), job.getEndDate()));
    }

    public Constraint beforeIdealEndDate(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Job.class).filter(job -> job.getIdealEndDate() != null && job.getEndDate().isBefore(job.getIdealEndDate())).penalizeLong("Before ideal end date", (Score)HardSoftLongScore.ofSoft((long)1L), job -> ChronoUnit.DAYS.between(job.getEndDate(), job.getIdealEndDate()));
    }

    public Constraint afterIdealEndDate(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Job.class).filter(job -> job.getIdealEndDate() != null && job.getEndDate().isAfter(job.getIdealEndDate())).penalizeLong("After ideal end date", (Score)HardSoftLongScore.ofSoft((long)1000000L), job -> ChronoUnit.DAYS.between(job.getIdealEndDate(), job.getEndDate()));
    }

    public Constraint tagConflict(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachUniquePair(Job.class, Joiners.overlapping(Job::getStartDate, Job::getEndDate), Joiners.filtering((job1, job2) -> !Collections.disjoint(job1.getTagSet(), job2.getTagSet()))).penalizeLong("Tag conflict", (Score)HardSoftLongScore.ofSoft((long)1000L), (job1, job2) -> {
            HashSet<String> intersection = new HashSet<String>(job1.getTagSet());
            intersection.retainAll(job2.getTagSet());
            long overlap = ChronoUnit.DAYS.between(job1.getStartDate().isAfter(job2.getStartDate()) ? job1.getStartDate() : job2.getStartDate(), job1.getEndDate().isBefore(job2.getEndDate()) ? job1.getEndDate() : job2.getEndDate());
            return (long)intersection.size() * overlap;
        });
    }
}

