/*
 * Decompiled with CFR 0.152.
 */
package org.acme.schooltimetabling.bootstrap;

import io.quarkus.runtime.StartupEvent;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.ArrayList;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.acme.schooltimetabling.domain.Lesson;
import org.acme.schooltimetabling.domain.Room;
import org.acme.schooltimetabling.domain.Timeslot;
import org.acme.schooltimetabling.persistence.LessonRepository;
import org.acme.schooltimetabling.persistence.RoomRepository;
import org.acme.schooltimetabling.persistence.TimeslotRepository;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class DemoDataGenerator {
    @ConfigProperty(name="timeTable.demoData", defaultValue="SMALL")
    DemoData demoData;
    @Inject
    TimeslotRepository timeslotRepository;
    @Inject
    RoomRepository roomRepository;
    @Inject
    LessonRepository lessonRepository;

    @Transactional
    public void generateDemoData(@Observes StartupEvent startupEvent) {
        if (this.demoData == DemoData.NONE) {
            return;
        }
        ArrayList<Timeslot> timeslotList = new ArrayList<Timeslot>(10);
        timeslotList.add(new Timeslot(DayOfWeek.MONDAY, LocalTime.of(8, 30), LocalTime.of(9, 30)));
        timeslotList.add(new Timeslot(DayOfWeek.MONDAY, LocalTime.of(9, 30), LocalTime.of(10, 30)));
        timeslotList.add(new Timeslot(DayOfWeek.MONDAY, LocalTime.of(10, 30), LocalTime.of(11, 30)));
        timeslotList.add(new Timeslot(DayOfWeek.MONDAY, LocalTime.of(13, 30), LocalTime.of(14, 30)));
        timeslotList.add(new Timeslot(DayOfWeek.MONDAY, LocalTime.of(14, 30), LocalTime.of(15, 30)));
        timeslotList.add(new Timeslot(DayOfWeek.TUESDAY, LocalTime.of(8, 30), LocalTime.of(9, 30)));
        timeslotList.add(new Timeslot(DayOfWeek.TUESDAY, LocalTime.of(9, 30), LocalTime.of(10, 30)));
        timeslotList.add(new Timeslot(DayOfWeek.TUESDAY, LocalTime.of(10, 30), LocalTime.of(11, 30)));
        timeslotList.add(new Timeslot(DayOfWeek.TUESDAY, LocalTime.of(13, 30), LocalTime.of(14, 30)));
        timeslotList.add(new Timeslot(DayOfWeek.TUESDAY, LocalTime.of(14, 30), LocalTime.of(15, 30)));
        if (this.demoData == DemoData.LARGE) {
            timeslotList.add(new Timeslot(DayOfWeek.WEDNESDAY, LocalTime.of(8, 30), LocalTime.of(9, 30)));
            timeslotList.add(new Timeslot(DayOfWeek.WEDNESDAY, LocalTime.of(9, 30), LocalTime.of(10, 30)));
            timeslotList.add(new Timeslot(DayOfWeek.WEDNESDAY, LocalTime.of(10, 30), LocalTime.of(11, 30)));
            timeslotList.add(new Timeslot(DayOfWeek.WEDNESDAY, LocalTime.of(13, 30), LocalTime.of(14, 30)));
            timeslotList.add(new Timeslot(DayOfWeek.WEDNESDAY, LocalTime.of(14, 30), LocalTime.of(15, 30)));
            timeslotList.add(new Timeslot(DayOfWeek.THURSDAY, LocalTime.of(8, 30), LocalTime.of(9, 30)));
            timeslotList.add(new Timeslot(DayOfWeek.THURSDAY, LocalTime.of(9, 30), LocalTime.of(10, 30)));
            timeslotList.add(new Timeslot(DayOfWeek.THURSDAY, LocalTime.of(10, 30), LocalTime.of(11, 30)));
            timeslotList.add(new Timeslot(DayOfWeek.THURSDAY, LocalTime.of(13, 30), LocalTime.of(14, 30)));
            timeslotList.add(new Timeslot(DayOfWeek.THURSDAY, LocalTime.of(14, 30), LocalTime.of(15, 30)));
            timeslotList.add(new Timeslot(DayOfWeek.FRIDAY, LocalTime.of(8, 30), LocalTime.of(9, 30)));
            timeslotList.add(new Timeslot(DayOfWeek.FRIDAY, LocalTime.of(9, 30), LocalTime.of(10, 30)));
            timeslotList.add(new Timeslot(DayOfWeek.FRIDAY, LocalTime.of(10, 30), LocalTime.of(11, 30)));
            timeslotList.add(new Timeslot(DayOfWeek.FRIDAY, LocalTime.of(13, 30), LocalTime.of(14, 30)));
            timeslotList.add(new Timeslot(DayOfWeek.FRIDAY, LocalTime.of(14, 30), LocalTime.of(15, 30)));
        }
        this.timeslotRepository.persist(timeslotList);
        ArrayList<Room> roomList = new ArrayList<Room>(3);
        roomList.add(new Room("Room A"));
        roomList.add(new Room("Room B"));
        roomList.add(new Room("Room C"));
        if (this.demoData == DemoData.LARGE) {
            roomList.add(new Room("Room D"));
            roomList.add(new Room("Room E"));
            roomList.add(new Room("Room F"));
        }
        this.roomRepository.persist(roomList);
        ArrayList<Lesson> lessonList = new ArrayList<Lesson>();
        lessonList.add(new Lesson("Math", "A. Turing", "9th grade"));
        lessonList.add(new Lesson("Math", "A. Turing", "9th grade"));
        lessonList.add(new Lesson("Physics", "M. Curie", "9th grade"));
        lessonList.add(new Lesson("Chemistry", "M. Curie", "9th grade"));
        lessonList.add(new Lesson("Biology", "C. Darwin", "9th grade"));
        lessonList.add(new Lesson("History", "I. Jones", "9th grade"));
        lessonList.add(new Lesson("English", "I. Jones", "9th grade"));
        lessonList.add(new Lesson("English", "I. Jones", "9th grade"));
        lessonList.add(new Lesson("Spanish", "P. Cruz", "9th grade"));
        lessonList.add(new Lesson("Spanish", "P. Cruz", "9th grade"));
        if (this.demoData == DemoData.LARGE) {
            lessonList.add(new Lesson("Math", "A. Turing", "9th grade"));
            lessonList.add(new Lesson("Math", "A. Turing", "9th grade"));
            lessonList.add(new Lesson("Math", "A. Turing", "9th grade"));
            lessonList.add(new Lesson("ICT", "A. Turing", "9th grade"));
            lessonList.add(new Lesson("Physics", "M. Curie", "9th grade"));
            lessonList.add(new Lesson("Geography", "C. Darwin", "9th grade"));
            lessonList.add(new Lesson("Geology", "C. Darwin", "9th grade"));
            lessonList.add(new Lesson("History", "I. Jones", "9th grade"));
            lessonList.add(new Lesson("English", "I. Jones", "9th grade"));
            lessonList.add(new Lesson("Drama", "I. Jones", "9th grade"));
            lessonList.add(new Lesson("Art", "S. Dali", "9th grade"));
            lessonList.add(new Lesson("Art", "S. Dali", "9th grade"));
            lessonList.add(new Lesson("Physical education", "C. Lewis", "9th grade"));
            lessonList.add(new Lesson("Physical education", "C. Lewis", "9th grade"));
            lessonList.add(new Lesson("Physical education", "C. Lewis", "9th grade"));
        }
        lessonList.add(new Lesson("Math", "A. Turing", "10th grade"));
        lessonList.add(new Lesson("Math", "A. Turing", "10th grade"));
        lessonList.add(new Lesson("Math", "A. Turing", "10th grade"));
        lessonList.add(new Lesson("Physics", "M. Curie", "10th grade"));
        lessonList.add(new Lesson("Chemistry", "M. Curie", "10th grade"));
        lessonList.add(new Lesson("French", "M. Curie", "10th grade"));
        lessonList.add(new Lesson("Geography", "C. Darwin", "10th grade"));
        lessonList.add(new Lesson("History", "I. Jones", "10th grade"));
        lessonList.add(new Lesson("English", "P. Cruz", "10th grade"));
        lessonList.add(new Lesson("Spanish", "P. Cruz", "10th grade"));
        if (this.demoData == DemoData.LARGE) {
            lessonList.add(new Lesson("Math", "A. Turing", "10th grade"));
            lessonList.add(new Lesson("Math", "A. Turing", "10th grade"));
            lessonList.add(new Lesson("ICT", "A. Turing", "10th grade"));
            lessonList.add(new Lesson("Physics", "M. Curie", "10th grade"));
            lessonList.add(new Lesson("Biology", "C. Darwin", "10th grade"));
            lessonList.add(new Lesson("Geology", "C. Darwin", "10th grade"));
            lessonList.add(new Lesson("History", "I. Jones", "10th grade"));
            lessonList.add(new Lesson("English", "P. Cruz", "10th grade"));
            lessonList.add(new Lesson("English", "P. Cruz", "10th grade"));
            lessonList.add(new Lesson("Drama", "I. Jones", "10th grade"));
            lessonList.add(new Lesson("Art", "S. Dali", "10th grade"));
            lessonList.add(new Lesson("Art", "S. Dali", "10th grade"));
            lessonList.add(new Lesson("Physical education", "C. Lewis", "10th grade"));
            lessonList.add(new Lesson("Physical education", "C. Lewis", "10th grade"));
            lessonList.add(new Lesson("Physical education", "C. Lewis", "10th grade"));
            lessonList.add(new Lesson("Math", "A. Turing", "11th grade"));
            lessonList.add(new Lesson("Math", "A. Turing", "11th grade"));
            lessonList.add(new Lesson("Math", "A. Turing", "11th grade"));
            lessonList.add(new Lesson("Math", "A. Turing", "11th grade"));
            lessonList.add(new Lesson("Math", "A. Turing", "11th grade"));
            lessonList.add(new Lesson("ICT", "A. Turing", "11th grade"));
            lessonList.add(new Lesson("Physics", "M. Curie", "11th grade"));
            lessonList.add(new Lesson("Chemistry", "M. Curie", "11th grade"));
            lessonList.add(new Lesson("French", "M. Curie", "11th grade"));
            lessonList.add(new Lesson("Physics", "M. Curie", "11th grade"));
            lessonList.add(new Lesson("Geography", "C. Darwin", "11th grade"));
            lessonList.add(new Lesson("Biology", "C. Darwin", "11th grade"));
            lessonList.add(new Lesson("Geology", "C. Darwin", "11th grade"));
            lessonList.add(new Lesson("History", "I. Jones", "11th grade"));
            lessonList.add(new Lesson("History", "I. Jones", "11th grade"));
            lessonList.add(new Lesson("English", "P. Cruz", "11th grade"));
            lessonList.add(new Lesson("English", "P. Cruz", "11th grade"));
            lessonList.add(new Lesson("English", "P. Cruz", "11th grade"));
            lessonList.add(new Lesson("Spanish", "P. Cruz", "11th grade"));
            lessonList.add(new Lesson("Drama", "P. Cruz", "11th grade"));
            lessonList.add(new Lesson("Art", "S. Dali", "11th grade"));
            lessonList.add(new Lesson("Art", "S. Dali", "11th grade"));
            lessonList.add(new Lesson("Physical education", "C. Lewis", "11th grade"));
            lessonList.add(new Lesson("Physical education", "C. Lewis", "11th grade"));
            lessonList.add(new Lesson("Physical education", "C. Lewis", "11th grade"));
            lessonList.add(new Lesson("Math", "A. Turing", "12th grade"));
            lessonList.add(new Lesson("Math", "A. Turing", "12th grade"));
            lessonList.add(new Lesson("Math", "A. Turing", "12th grade"));
            lessonList.add(new Lesson("Math", "A. Turing", "12th grade"));
            lessonList.add(new Lesson("Math", "A. Turing", "12th grade"));
            lessonList.add(new Lesson("ICT", "A. Turing", "12th grade"));
            lessonList.add(new Lesson("Physics", "M. Curie", "12th grade"));
            lessonList.add(new Lesson("Chemistry", "M. Curie", "12th grade"));
            lessonList.add(new Lesson("French", "M. Curie", "12th grade"));
            lessonList.add(new Lesson("Physics", "M. Curie", "12th grade"));
            lessonList.add(new Lesson("Geography", "C. Darwin", "12th grade"));
            lessonList.add(new Lesson("Biology", "C. Darwin", "12th grade"));
            lessonList.add(new Lesson("Geology", "C. Darwin", "12th grade"));
            lessonList.add(new Lesson("History", "I. Jones", "12th grade"));
            lessonList.add(new Lesson("History", "I. Jones", "12th grade"));
            lessonList.add(new Lesson("English", "P. Cruz", "12th grade"));
            lessonList.add(new Lesson("English", "P. Cruz", "12th grade"));
            lessonList.add(new Lesson("English", "P. Cruz", "12th grade"));
            lessonList.add(new Lesson("Spanish", "P. Cruz", "12th grade"));
            lessonList.add(new Lesson("Drama", "P. Cruz", "12th grade"));
            lessonList.add(new Lesson("Art", "S. Dali", "12th grade"));
            lessonList.add(new Lesson("Art", "S. Dali", "12th grade"));
            lessonList.add(new Lesson("Physical education", "C. Lewis", "12th grade"));
            lessonList.add(new Lesson("Physical education", "C. Lewis", "12th grade"));
            lessonList.add(new Lesson("Physical education", "C. Lewis", "12th grade"));
        }
        Lesson lesson = (Lesson)lessonList.get(0);
        lesson.setTimeslot((Timeslot)timeslotList.get(0));
        lesson.setRoom((Room)roomList.get(0));
        this.lessonRepository.persist(lessonList);
    }

    public static enum DemoData {
        NONE,
        SMALL,
        LARGE;

    }
}

