/*
 * Decompiled with CFR 0.152.
 */
package org.acme.schooltimetabling.rest;

import io.quarkus.panache.common.Sort;
import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.acme.schooltimetabling.domain.Lesson;
import org.acme.schooltimetabling.domain.TimeTable;
import org.acme.schooltimetabling.persistence.LessonRepository;
import org.acme.schooltimetabling.persistence.RoomRepository;
import org.acme.schooltimetabling.persistence.TimeslotRepository;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.api.solver.SolverStatus;

@Path(value="timeTable")
public class TimeTableResource {
    public static final Long SINGLETON_TIME_TABLE_ID = 1L;
    @Inject
    TimeslotRepository timeslotRepository;
    @Inject
    RoomRepository roomRepository;
    @Inject
    LessonRepository lessonRepository;
    @Inject
    SolverManager<TimeTable, Long> solverManager;
    @Inject
    ScoreManager<TimeTable, HardSoftScore> scoreManager;

    @GET
    public TimeTable getTimeTable() {
        SolverStatus solverStatus = this.getSolverStatus();
        TimeTable solution = this.findById(SINGLETON_TIME_TABLE_ID);
        this.scoreManager.updateScore((Object)solution);
        solution.setSolverStatus(solverStatus);
        return solution;
    }

    @POST
    @Path(value="solve")
    public void solve() {
        this.solverManager.solveAndListen((Object)SINGLETON_TIME_TABLE_ID, this::findById, this::save);
    }

    public SolverStatus getSolverStatus() {
        return this.solverManager.getSolverStatus((Object)SINGLETON_TIME_TABLE_ID);
    }

    @POST
    @Path(value="stopSolving")
    public void stopSolving() {
        this.solverManager.terminateEarly((Object)SINGLETON_TIME_TABLE_ID);
    }

    @Transactional
    protected TimeTable findById(Long id) {
        if (!SINGLETON_TIME_TABLE_ID.equals(id)) {
            throw new IllegalStateException("There is no timeTable with id (" + id + ").");
        }
        return new TimeTable(this.timeslotRepository.listAll(Sort.by((String)"dayOfWeek").and("startTime").and("endTime").and("id")), this.roomRepository.listAll(Sort.by((String)"name").and("id")), this.lessonRepository.listAll(Sort.by((String)"subject").and("teacher").and("studentGroup").and("id")));
    }

    @Transactional
    protected void save(TimeTable timeTable) {
        for (Lesson lesson : timeTable.getLessonList()) {
            Lesson attachedLesson = (Lesson)this.lessonRepository.findById(lesson.getId());
            attachedLesson.setTimeslot(lesson.getTimeslot());
            attachedLesson.setRoom(lesson.getRoom());
        }
    }
}

