/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.uni;

import java.util.Set;
import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.tri.BavetGroupTriConstraintStream;
import org.optaplanner.constraint.streams.bavet.tri.TriTuple;
import org.optaplanner.constraint.streams.bavet.uni.AbstractGroupUniNode;
import org.optaplanner.constraint.streams.bavet.uni.BavetAbstractUniConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.UniGroupNodeConstructor;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;

final class BavetTriGroupBridgeUniConstraintStream<Solution_, A, NewA, NewB, NewC>
extends BavetAbstractUniConstraintStream<Solution_, A> {
    private final BavetAbstractUniConstraintStream<Solution_, A> parent;
    private BavetGroupTriConstraintStream<Solution_, NewA, NewB, NewC> groupStream;
    private final UniGroupNodeConstructor<A, TriTuple<NewA, NewB, NewC>> nodeConstructor;

    public BavetTriGroupBridgeUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, UniGroupNodeConstructor<A, TriTuple<NewA, NewB, NewC>> nodeConstructor) {
        super(constraintFactory, parent.getRetrievalSemantics());
        this.parent = parent;
        this.nodeConstructor = nodeConstructor;
    }

    public boolean guaranteesDistinct() {
        return true;
    }

    public void setGroupStream(BavetGroupTriConstraintStream<Solution_, NewA, NewB, NewC> groupStream) {
        this.groupStream = groupStream;
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.parent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        if (!this.childStreamList.isEmpty()) {
            throw new IllegalStateException("Impossible state: the stream (" + this + ") has an non-empty childStreamList (" + this.childStreamList + ") but it's a groupBy bridge.");
        }
        int inputStoreIndex = buildHelper.reserveTupleStoreIndex(this.parent.getTupleSource());
        Consumer insert = buildHelper.getAggregatedInsert(this.groupStream.getChildStreamList());
        Consumer retract = buildHelper.getAggregatedRetract(this.groupStream.getChildStreamList());
        int outputStoreSize = buildHelper.extractTupleStoreSize((ConstraintStream)this.groupStream);
        AbstractGroupUniNode<A, TriTuple<NewA, NewB, NewC>, ?, ?, ?> node = this.nodeConstructor.apply(inputStoreIndex, insert, retract, outputStoreSize);
        buildHelper.addNode(node);
        buildHelper.putInsertUpdateRetract((ConstraintStream)this, node::insert, node::update, node::retract);
    }

    @Override
    public ConstraintStream getTupleSource() {
        return this.parent.getTupleSource();
    }
}

