/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public abstract class AbstractIfExistsNode<LeftTuple_ extends Tuple, Right_>
extends AbstractNode {
    private final boolean shouldExist;
    private final Function<Right_, IndexProperties> mappingRight;
    private final int inputStoreIndexLeft;
    private final int inputStoreIndexRight;
    private final Consumer<LeftTuple_> nextNodesInsert;
    private final Consumer<LeftTuple_> nextNodesRetract;
    private final Indexer<LeftTuple_, Counter<LeftTuple_>> indexerLeft;
    private final Indexer<UniTuple<Right_>, Set<Counter<LeftTuple_>>> indexerRight;
    private final Queue<Counter<LeftTuple_>> dirtyCounterQueue;

    protected AbstractIfExistsNode(boolean shouldExist, Function<Right_, IndexProperties> mappingRight, int inputStoreIndexLeft, int inputStoreIndexRight, Consumer<LeftTuple_> nextNodesInsert, Consumer<LeftTuple_> nextNodesRetract, Indexer<LeftTuple_, Counter<LeftTuple_>> indexerLeft, Indexer<UniTuple<Right_>, Set<Counter<LeftTuple_>>> indexerRight) {
        this.shouldExist = shouldExist;
        this.mappingRight = mappingRight;
        this.inputStoreIndexLeft = inputStoreIndexLeft;
        this.inputStoreIndexRight = inputStoreIndexRight;
        this.nextNodesInsert = nextNodesInsert;
        this.nextNodesRetract = nextNodesRetract;
        this.indexerLeft = indexerLeft;
        this.indexerRight = indexerRight;
        this.dirtyCounterQueue = new ArrayDeque<Counter<LeftTuple_>>(1000);
    }

    public final void insertLeft(LeftTuple_ leftTuple) {
        Object[] tupleStore = leftTuple.getStore();
        if (tupleStore[this.inputStoreIndexLeft] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + leftTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.createIndexProperties(leftTuple);
        tupleStore[this.inputStoreIndexLeft] = indexProperties;
        Counter<LeftTuple_> counter = new Counter<LeftTuple_>(leftTuple);
        this.indexerLeft.put(indexProperties, leftTuple, counter);
        counter.countRight = 0;
        this.indexerRight.visit(indexProperties, (rightTuple, counterSetRight) -> {
            if (!this.isFiltering() || this.isFiltered(leftTuple, (UniTuple<Right_>)rightTuple)) {
                ++counter.countRight;
                counterSetRight.add(counter);
            }
        });
        if (this.shouldExist ? counter.countRight > 0 : counter.countRight == 0) {
            counter.state = BavetTupleState.CREATING;
            this.dirtyCounterQueue.add(counter);
        }
    }

    public void updateLeft(LeftTuple_ leftTuple) {
        this.retractLeft(leftTuple);
        this.insertLeft(leftTuple);
    }

    public final void retractLeft(LeftTuple_ leftTuple) {
        Object[] tupleStore = leftTuple.getStore();
        IndexProperties indexProperties = (IndexProperties)tupleStore[this.inputStoreIndexLeft];
        if (indexProperties == null) {
            return;
        }
        tupleStore[this.inputStoreIndexLeft] = null;
        Counter<LeftTuple_> counter = this.indexerLeft.remove(indexProperties, leftTuple);
        this.indexerRight.visit(indexProperties, (rightTuple, counterSetRight) -> {
            boolean changed = counterSetRight.remove(counter);
            if (!changed && !this.isFiltering()) {
                throw new IllegalStateException("Impossible state: the tuple (" + leftTuple + ") with indexProperties (" + indexProperties + ") has a counter on the AB side that doesn't exist on the C side.");
            }
        });
        if (this.shouldExist ? counter.countRight > 0 : counter.countRight == 0) {
            this.retractCounter(counter);
        }
    }

    public void updateRight(UniTuple<Right_> rightTuple) {
        this.retractRight(rightTuple);
        this.insertRight(rightTuple);
    }

    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.store[this.inputStoreIndexRight] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + rightTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingRight.apply(rightTuple.factA);
        rightTuple.store[this.inputStoreIndexRight] = indexProperties;
        LinkedHashSet counterSetRight = new LinkedHashSet();
        this.indexerRight.put(indexProperties, rightTuple, counterSetRight);
        this.indexerLeft.visit(indexProperties, (leftTuple, counter) -> {
            if (!this.isFiltering() || this.isFiltered(leftTuple, rightTuple)) {
                if (counter.countRight == 0) {
                    if (this.shouldExist) {
                        this.insertCounter((Counter<LeftTuple_>)counter);
                    } else {
                        this.retractCounter((Counter<LeftTuple_>)counter);
                    }
                }
                ++counter.countRight;
                counterSetRight.add(counter);
            }
        });
    }

    public final void retractRight(UniTuple<Right_> rightTuple) {
        Object[] tupleStore = rightTuple.store;
        IndexProperties indexProperties = (IndexProperties)tupleStore[this.inputStoreIndexRight];
        if (indexProperties == null) {
            return;
        }
        tupleStore[this.inputStoreIndexRight] = null;
        Set<Counter<LeftTuple_>> counterSetRight = this.indexerRight.remove(indexProperties, rightTuple);
        for (Counter<LeftTuple_> counter : counterSetRight) {
            --counter.countRight;
            if (counter.countRight != 0) continue;
            if (this.shouldExist) {
                this.retractCounter(counter);
                continue;
            }
            this.insertCounter(counter);
        }
    }

    protected abstract IndexProperties createIndexProperties(LeftTuple_ var1);

    protected abstract boolean isFiltering();

    protected abstract boolean isFiltered(LeftTuple_ var1, UniTuple<Right_> var2);

    private void insertCounter(Counter<LeftTuple_> counter) {
        switch (counter.state) {
            case DYING: {
                counter.state = BavetTupleState.UPDATING;
                break;
            }
            case DEAD: {
                counter.state = BavetTupleState.CREATING;
                this.dirtyCounterQueue.add(counter);
                break;
            }
            case ABORTING: {
                counter.state = BavetTupleState.CREATING;
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: the counter (" + counter + ") has an impossible insert state (" + counter.state + ").");
            }
        }
    }

    private void retractCounter(Counter<LeftTuple_> counter) {
        switch (counter.state) {
            case CREATING: {
                counter.state = BavetTupleState.ABORTING;
                break;
            }
            case UPDATING: {
                counter.state = BavetTupleState.DYING;
                break;
            }
            case OK: {
                counter.state = BavetTupleState.DYING;
                this.dirtyCounterQueue.add(counter);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The counter (" + counter + ") has an impossible retract state (" + counter.state + ").");
            }
        }
    }

    @Override
    public void calculateScore() {
        this.dirtyCounterQueue.forEach(counter -> {
            switch (counter.state) {
                case CREATING: {
                    this.nextNodesInsert.accept(counter.leftTuple);
                    counter.state = BavetTupleState.OK;
                    break;
                }
                case UPDATING: {
                    this.nextNodesRetract.accept(counter.leftTuple);
                    this.nextNodesInsert.accept(counter.leftTuple);
                    counter.state = BavetTupleState.OK;
                    break;
                }
                case DYING: {
                    this.nextNodesRetract.accept(counter.leftTuple);
                    counter.state = BavetTupleState.DEAD;
                    break;
                }
                case ABORTING: {
                    counter.state = BavetTupleState.DEAD;
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible state: The dirty counter (" + counter + ") has an non-dirty state (" + counter.state + ").");
                }
            }
        });
        this.dirtyCounterQueue.clear();
    }

    public static final class Counter<Tuple_ extends Tuple> {
        public final Tuple_ leftTuple;
        public BavetTupleState state = BavetTupleState.DEAD;
        public int countRight = 0;

        public Counter(Tuple_ leftTuple) {
            this.leftTuple = leftTuple;
        }

        public String toString() {
            return "Counter(" + this.leftTuple + ")";
        }
    }
}

