/*
 * Decompiled with CFR 0.152.
 */
package org.crac;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.crac.CheckpointException;
import org.crac.Context;
import org.crac.GlobalContextWrapper;
import org.crac.Resource;
import org.crac.RestoreException;

public class Core {
    private static final Context<Resource> globalContextWrapper;
    private static final Compat compat;

    public static Context<Resource> getGlobalContext() {
        return globalContextWrapper;
    }

    public static void checkpointRestore() throws CheckpointException, RestoreException {
        if (compat == null) {
            throw new UnsupportedOperationException();
        }
        compat.checkpointRestore();
    }

    static void register(Resource r) {
        if (compat != null) {
            compat.register(r);
        }
    }

    static {
        Compat candidate;
        globalContextWrapper = new GlobalContextWrapper();
        try {
            candidate = new CompatMaster();
        }
        catch (Throwable t) {
            try {
                candidate = new CompatJdk();
            }
            catch (Throwable t2) {
                candidate = null;
            }
        }
        compat = candidate;
    }

    static class CompatJdk
    extends Compat {
        CompatJdk() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            super("jdk.crac");
        }
    }

    static class CompatMaster
    extends Compat {
        CompatMaster() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            super("javax.crac");
        }
    }

    static abstract class Compat {
        protected Class clsResource;
        protected Class clsContext;
        protected Class clsCore;
        protected Class clsCheckpointException;
        protected Class clsRestoreException;
        protected final Method checkpointRestore;
        protected final Method register;
        protected final Object globalContext;
        protected List<Exception> registerExceptions = new ArrayList<Exception>();

        protected Compat(String pkg) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            this.clsResource = Class.forName(pkg + ".Resource");
            this.clsContext = Class.forName(pkg + ".Context");
            this.clsCore = Class.forName(pkg + ".Core");
            this.clsCheckpointException = Class.forName(pkg + ".CheckpointException");
            this.clsRestoreException = Class.forName(pkg + ".RestoreException");
            this.checkpointRestore = this.clsCore.getMethod("checkpointRestore", new Class[0]);
            this.register = this.clsContext.getMethod("register", this.clsResource);
            this.globalContext = this.clsCore.getMethod("getGlobalContext", new Class[0]).invoke(null, new Object[0]);
        }

        public void checkpointRestore() throws CheckpointException, RestoreException {
            if (this.registerExceptions.size() != 0) {
                throw new UnsupportedOperationException();
            }
            try {
                this.checkpointRestore.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ite) {
                if (this.clsCheckpointException.isInstance(ite.getCause())) {
                    CheckpointException checkpointException = new CheckpointException();
                    for (Throwable t : ite.getCause().getSuppressed()) {
                        checkpointException.addSuppressed(t);
                    }
                    throw checkpointException;
                }
                if (this.clsRestoreException.isInstance(ite.getCause())) {
                    RestoreException restoreException = new RestoreException();
                    for (Throwable t : ite.getCause().getSuppressed()) {
                        restoreException.addSuppressed(t);
                    }
                    throw restoreException;
                }
                CheckpointException checkpointException = new CheckpointException();
                checkpointException.addSuppressed(ite);
                throw checkpointException;
            }
        }

        public void register(Resource resource) {
            try {
                ResourceWrapper resourceWrapper = new ResourceWrapper(resource);
                Object proxy = Proxy.newProxyInstance(Compat.class.getClassLoader(), new Class[]{this.clsResource}, (InvocationHandler)resourceWrapper);
                resourceWrapper.setProxy(proxy);
                this.register.invoke(this.globalContext, proxy);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.registerExceptions.add(e);
            }
        }
    }

    static class ResourceWrapper
    extends WeakReference<Resource>
    implements InvocationHandler {
        private static WeakHashMap<Resource, ResourceWrapper> weakMap = new WeakHashMap();
        private Object proxy;
        private Resource strongRef;

        public void setProxy(Object proxy) {
            this.proxy = proxy;
        }

        public ResourceWrapper(Resource referent) {
            super(referent);
            weakMap.put(referent, this);
            this.strongRef = null;
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            String name = m.getName();
            if ("beforeCheckpoint".equals(name)) {
                this.beforeCheckpoint();
                return null;
            }
            if ("afterRestore".equals(name)) {
                this.afterRestore();
                return null;
            }
            if ("toString".equals(name)) {
                return this.toString();
            }
            try {
                return m.invoke(this.get(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private void beforeCheckpoint() throws Exception {
            Resource r;
            this.strongRef = r = (Resource)this.get();
            if (r != null) {
                r.beforeCheckpoint(globalContextWrapper);
            }
        }

        private void afterRestore() throws Exception {
            Resource r = (Resource)this.get();
            this.strongRef = null;
            if (r != null) {
                r.afterRestore(globalContextWrapper);
            }
        }

        public String toString() {
            return "org.crac.ResourceWrapper[" + ((Resource)this.get()).toString() + "]";
        }
    }
}

