/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common.accessor.gizmo;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.AbstractGizmoMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.AbstractReadOnlyGizmoMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.AbstractReadWriteGizmoMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorFactory;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberDescriptor;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberInfo;

public class GizmoMemberAccessorImplementor {
    private static final Map<String, byte[]> classNameToBytecode = new HashMap<String, byte[]>();
    private static final ClassLoader GIZMO_CLASS_LOADER = new ClassLoader(){

        @Override
        public String getName() {
            return "OptaPlanner Gizmo MemberAccessor ClassLoader";
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            if (classNameToBytecode.containsKey(name)) {
                byte[] byteCode = classNameToBytecode.get(name);
                return this.defineClass(name, byteCode, 0, byteCode.length);
            }
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
    };
    static final String GENERIC_TYPE_FIELD = "genericType";
    static final String ANNOTATED_ELEMENT_FIELD = "annotatedElement";

    public static void defineAccessorFor(String className, ClassOutput classOutput, GizmoMemberInfo memberInfo) {
        Class<? extends AbstractGizmoMemberAccessor> superClass = GizmoMemberAccessorImplementor.getCorrectSuperclass(memberInfo);
        try (ClassCreator classCreator = ClassCreator.builder().className(className).superClass(superClass).classOutput(classOutput).setFinal(true).build();){
            classCreator.getFieldCreator(GENERIC_TYPE_FIELD, Type.class).setModifiers(16);
            classCreator.getFieldCreator(ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class).setModifiers(16);
            GizmoMemberAccessorImplementor.createConstructor(classCreator, memberInfo);
            GizmoMemberAccessorImplementor.createGetDeclaringClass(classCreator, memberInfo);
            GizmoMemberAccessorImplementor.createGetType(classCreator, memberInfo);
            GizmoMemberAccessorImplementor.createGetGenericType(classCreator);
            GizmoMemberAccessorImplementor.createGetName(classCreator, memberInfo);
            GizmoMemberAccessorImplementor.createExecuteGetter(classCreator, memberInfo);
            if (superClass == AbstractReadWriteGizmoMemberAccessor.class) {
                GizmoMemberAccessorImplementor.createExecuteSetter(classCreator, memberInfo);
            }
            GizmoMemberAccessorImplementor.createGetAnnotation(classCreator);
        }
    }

    private static Class<? extends AbstractGizmoMemberAccessor> getCorrectSuperclass(GizmoMemberInfo memberInfo) {
        AtomicBoolean supportsSetter = new AtomicBoolean();
        memberInfo.getDescriptor().whenIsMethod(method -> supportsSetter.set(memberInfo.getDescriptor().getSetter().isPresent()));
        memberInfo.getDescriptor().whenIsField(field -> supportsSetter.set(true));
        if (supportsSetter.get()) {
            return AbstractReadWriteGizmoMemberAccessor.class;
        }
        return AbstractReadOnlyGizmoMemberAccessor.class;
    }

    public static MemberAccessor createAccessorFor(Member member, Class<? extends Annotation> annotationClass) {
        String className = GizmoMemberAccessorFactory.getGeneratedClassName(member);
        if (classNameToBytecode.containsKey(className)) {
            return GizmoMemberAccessorImplementor.createInstance(className);
        }
        byte[][] classBytecodeHolder = new byte[1][];
        ClassOutput classOutput = (path, byteCode) -> {
            classBytecodeHolder[0] = byteCode;
        };
        GizmoMemberInfo memberInfo = new GizmoMemberInfo(new GizmoMemberDescriptor(member), annotationClass);
        GizmoMemberAccessorImplementor.defineAccessorFor(className, classOutput, memberInfo);
        byte[] classBytecode = classBytecodeHolder[0];
        classNameToBytecode.put(className, classBytecode);
        return GizmoMemberAccessorImplementor.createInstance(className);
    }

    private static MemberAccessor createInstance(String className) {
        try {
            return (MemberAccessor)GIZMO_CLASS_LOADER.loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static MethodCreator getMethodCreator(ClassCreator classCreator, String methodName, Class<?> ... parameters) {
        try {
            return classCreator.getMethodCreator(MethodDescriptor.ofMethod((Method)MemberAccessor.class.getMethod(methodName, parameters)));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No such method: " + methodName, e);
        }
    }

    private static void createConstructor(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)classCreator.getClassName(), (String[])new String[0]));
        ResultHandle thisObj = methodCreator.getThis();
        methodCreator.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)classCreator.getSuperClass(), (String[])new String[0]), thisObj, new ResultHandle[0]);
        ResultHandle declaringClass = methodCreator.loadClass(memberInfo.getDescriptor().getDeclaringClassName());
        memberInfo.getDescriptor().whenMetadataIsOnField(fd -> {
            TryBlock tryBlock = methodCreator.tryBlock();
            ResultHandle name = tryBlock.load(fd.getName());
            ResultHandle field = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), declaringClass, new ResultHandle[]{name});
            ResultHandle type = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Field.class, (String)"getGenericType", Type.class, (Class[])new Class[0]), field, new ResultHandle[0]);
            tryBlock.writeInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)GENERIC_TYPE_FIELD, Type.class), thisObj, type);
            tryBlock.writeInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class), thisObj, field);
            tryBlock.addCatch(NoSuchFieldException.class).throwException(IllegalStateException.class, "Unable to find field (" + fd.getName() + ") in class (" + fd.getDeclaringClass() + ").");
        });
        memberInfo.getDescriptor().whenMetadataIsOnMethod(md -> {
            TryBlock tryBlock = methodCreator.tryBlock();
            ResultHandle name = tryBlock.load(md.getName());
            ResultHandle method = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), declaringClass, new ResultHandle[]{name, tryBlock.newArray(Class.class, 0)});
            ResultHandle type = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Method.class, (String)"getGenericReturnType", Type.class, (Class[])new Class[0]), method, new ResultHandle[0]);
            tryBlock.writeInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)GENERIC_TYPE_FIELD, Type.class), thisObj, type);
            tryBlock.writeInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class), thisObj, method);
            tryBlock.addCatch(NoSuchMethodException.class).throwException(IllegalStateException.class, "Unable to find method (" + md.getName() + ") in class (" + md.getDeclaringClass() + ").");
        });
        methodCreator.returnValue(thisObj);
    }

    private static void createGetDeclaringClass(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, "getDeclaringClass", new Class[0]);
        ResultHandle out = methodCreator.loadClass(memberInfo.getDescriptor().getDeclaringClassName());
        methodCreator.returnValue(out);
    }

    private static void assertIsGoodMethod(MethodDescriptor method, Class<? extends Annotation> annotationClass) {
        String methodName = method.getName();
        if (method.getParameterTypes().length != 0) {
            throw new IllegalStateException("The getterMethod (" + methodName + ") with a " + annotationClass.getSimpleName() + " annotation must not have any parameters, but has parameters (" + Arrays.toString(method.getParameterTypes()) + ").");
        }
        if (methodName.startsWith("get")) {
            if (method.getReturnType().equals("V")) {
                throw new IllegalStateException("The getterMethod (" + methodName + ") with a " + annotationClass.getSimpleName() + " annotation must have a non-void return type.");
            }
        } else if (methodName.startsWith("is")) {
            if (!method.getReturnType().equals("Z")) {
                throw new IllegalStateException("The getterMethod (" + methodName + ") with a " + annotationClass.getSimpleName() + " annotation must have a primitive boolean return type but returns (" + method.getReturnType() + "). Maybe rename the method (get" + methodName.substring(2) + ")?");
            }
        } else if (method.getReturnType().equals("V")) {
            throw new IllegalStateException("The readMethod (" + methodName + ") with a " + annotationClass.getSimpleName() + " annotation must have a non-void return type.");
        }
    }

    private static void createGetName(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, "getName", new Class[0]);
        memberInfo.getDescriptor().whenIsMethod(method -> GizmoMemberAccessorImplementor.assertIsGoodMethod(method, memberInfo.getAnnotationClass()));
        String fieldName = memberInfo.getDescriptor().getName();
        ResultHandle out = methodCreator.load(fieldName);
        methodCreator.returnValue(out);
    }

    private static void createGetType(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, "getType", new Class[0]);
        ResultHandle out = methodCreator.loadClass(memberInfo.getDescriptor().getTypeName());
        methodCreator.returnValue(out);
    }

    private static void createGetGenericType(ClassCreator classCreator) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, "getGenericType", new Class[0]);
        ResultHandle thisObj = methodCreator.getThis();
        ResultHandle out = methodCreator.readInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)GENERIC_TYPE_FIELD, Type.class), thisObj);
        methodCreator.returnValue(out);
    }

    private static void createExecuteGetter(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, "executeGetter", Object.class);
        ResultHandle bean = methodCreator.getMethodParam(0);
        methodCreator.returnValue(memberInfo.getDescriptor().readMemberValue((BytecodeCreator)methodCreator, bean));
    }

    private static void createExecuteSetter(ClassCreator classCreator, GizmoMemberInfo memberInfo) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getMethodCreator(classCreator, "executeSetter", Object.class, Object.class);
        ResultHandle bean = methodCreator.getMethodParam(0);
        ResultHandle value = methodCreator.getMethodParam(1);
        if (memberInfo.getDescriptor().writeMemberValue((BytecodeCreator)methodCreator, bean, value)) {
            methodCreator.returnValue(null);
        } else {
            methodCreator.throwException(UnsupportedOperationException.class, "Setter not supported");
        }
    }

    private static MethodCreator getAnnotationMethodCreator(ClassCreator classCreator, String methodName, Class<?> ... parameters) {
        return classCreator.getMethodCreator(GizmoMemberAccessorImplementor.getAnnotationMethod(methodName, parameters));
    }

    private static MethodDescriptor getAnnotationMethod(String methodName, Class<?> ... parameters) {
        try {
            return MethodDescriptor.ofMethod((Method)AnnotatedElement.class.getMethod(methodName, parameters));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No such method: " + methodName, e);
        }
    }

    private static void createGetAnnotation(ClassCreator classCreator) {
        MethodCreator methodCreator = GizmoMemberAccessorImplementor.getAnnotationMethodCreator(classCreator, "getAnnotation", Class.class);
        ResultHandle thisObj = methodCreator.getThis();
        ResultHandle annotatedElement = methodCreator.readInstanceField(FieldDescriptor.of((String)classCreator.getClassName(), (String)ANNOTATED_ELEMENT_FIELD, AnnotatedElement.class), thisObj);
        ResultHandle query = methodCreator.getMethodParam(0);
        ResultHandle out = methodCreator.invokeInterfaceMethod(GizmoMemberAccessorImplementor.getAnnotationMethod("getAnnotation", Class.class), annotatedElement, new ResultHandle[]{query});
        methodCreator.returnValue(out);
    }

    private GizmoMemberAccessorImplementor() {
    }
}

