/*
 * Decompiled with CFR 0.152.
 */
package org.acme.callcenter.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.acme.callcenter.domain.Call;
import org.acme.callcenter.domain.PreviousCallOrAgent;
import org.acme.callcenter.domain.Skill;

public class Agent
extends PreviousCallOrAgent {
    private String name;
    private Set<Skill> skills;

    public Agent() {
    }

    public Agent(long id, String name) {
        super(id);
        this.name = name;
        this.skills = EnumSet.noneOf(Skill.class);
    }

    public Agent(long id, String name, Set<Skill> skills) {
        super(id);
        this.name = name;
        this.skills = EnumSet.copyOf(skills);
    }

    public Agent(long id, String name, Skill ... skills) {
        this(id, name, EnumSet.copyOf(Arrays.asList(skills)));
    }

    @JsonProperty(value="calls", access=JsonProperty.Access.READ_ONLY)
    public List<Call> getAssignedCalls() {
        ArrayList<Call> assignedCalls = new ArrayList<Call>();
        for (Call nextCall = this.getNextCall(); nextCall != null; nextCall = nextCall.getNextCall()) {
            assignedCalls.add(nextCall);
        }
        return assignedCalls;
    }

    @Override
    public Duration getDurationTillPickUp() {
        return Duration.ZERO;
    }

    public String getName() {
        return this.name;
    }

    public Set<Skill> getSkills() {
        return this.skills;
    }

    public String $get$optaplanner$__field$__name() {
        return this.name;
    }

    public void $set$optaplanner$__field$__name(String string) {
        this.name = string;
    }

    public Set $get$optaplanner$__field$__skills() {
        return this.skills;
    }

    public void $set$optaplanner$__field$__skills(Set set) {
        this.skills = set;
    }
}

