/*
 * Decompiled with CFR 0.152.
 */
package org.acme.callcenter.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.acme.callcenter.domain.Agent;
import org.acme.callcenter.domain.PreviousCallOrAgent;
import org.acme.callcenter.domain.Skill;
import org.acme.callcenter.solver.ResponseTimeUpdatingVariableListener;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.entity.PlanningPin;
import org.optaplanner.core.api.domain.variable.AnchorShadowVariable;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableGraphType;
import org.optaplanner.core.api.domain.variable.PlanningVariableReference;

@PlanningEntity
public class Call
extends PreviousCallOrAgent {
    private String phoneNumber;
    private Set<Skill> requiredSkills;
    private Duration duration = Duration.ZERO;
    private LocalTime startTime;
    private LocalTime pickUpTime;
    @PlanningPin
    private boolean pinned;
    @JsonIgnore
    @PlanningVariable(valueRangeProviderRefs={"agentRange", "callRange"}, graphType=PlanningVariableGraphType.CHAINED)
    private PreviousCallOrAgent previousCallOrAgent;
    @JsonIgnore
    @AnchorShadowVariable(sourceVariableName="previousCallOrAgent")
    private Agent agent;
    @CustomShadowVariable(variableListenerClass=ResponseTimeUpdatingVariableListener.class, sources={@PlanningVariableReference(variableName="previousCallOrAgent")})
    private Duration estimatedWaiting;

    public Call() {
    }

    public Call(long id, String phoneNumber) {
        super(id);
        this.phoneNumber = phoneNumber;
        this.requiredSkills = EnumSet.noneOf(Skill.class);
        this.startTime = LocalTime.now();
    }

    public Call(long id, String phoneNumber, Set<Skill> requiredSkills, int durationSeconds) {
        super(id);
        this.phoneNumber = phoneNumber;
        this.requiredSkills = EnumSet.copyOf(requiredSkills);
        this.duration = Duration.ofSeconds(durationSeconds);
        this.startTime = LocalTime.now();
    }

    public Call(long id, String phoneNumber, Skill ... requiredSkills) {
        this(id, phoneNumber);
        this.requiredSkills.addAll(Arrays.asList(requiredSkills));
    }

    public int getMissingSkillCount() {
        if (this.agent == null) {
            return 0;
        }
        return (int)this.requiredSkills.stream().filter(skill -> !this.agent.getSkills().contains(skill)).count();
    }

    @Override
    public Duration getDurationTillPickUp() {
        if (this.estimatedWaiting == null) {
            return null;
        }
        Duration durationTillPickUp = this.estimatedWaiting.plus(this.getDuration());
        if (this.pickUpTime != null) {
            durationTillPickUp = durationTillPickUp.minus(Duration.between(this.pickUpTime, LocalTime.now()));
        }
        return durationTillPickUp;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public Set<Skill> getRequiredSkills() {
        return this.requiredSkills;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public PreviousCallOrAgent getPreviousCallOrAgent() {
        return this.previousCallOrAgent;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public Duration getEstimatedWaiting() {
        return this.estimatedWaiting;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public void setPreviousCallOrAgent(PreviousCallOrAgent previousCallOrAgent) {
        this.previousCallOrAgent = previousCallOrAgent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    public void setEstimatedWaiting(Duration estimatedWaiting) {
        this.estimatedWaiting = estimatedWaiting;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public LocalTime getPickUpTime() {
        return this.pickUpTime;
    }

    public void setPickUpTime(LocalTime pickUpTime) {
        this.pickUpTime = pickUpTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Call)) {
            return false;
        }
        Call call = (Call)o;
        return this.getId().equals(call.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public boolean $get$optaplanner$__field$__pinned() {
        return this.pinned;
    }

    public void $set$optaplanner$__field$__pinned(boolean bl) {
        this.pinned = bl;
    }

    public PreviousCallOrAgent $get$optaplanner$__field$__previousCallOrAgent() {
        return this.previousCallOrAgent;
    }

    public void $set$optaplanner$__field$__previousCallOrAgent(PreviousCallOrAgent previousCallOrAgent) {
        this.previousCallOrAgent = previousCallOrAgent;
    }

    public Agent $get$optaplanner$__field$__agent() {
        return this.agent;
    }

    public void $set$optaplanner$__field$__agent(Agent agent) {
        this.agent = agent;
    }

    public Duration $get$optaplanner$__field$__estimatedWaiting() {
        return this.estimatedWaiting;
    }

    public void $set$optaplanner$__field$__estimatedWaiting(Duration duration) {
        this.estimatedWaiting = duration;
    }

    public String $get$optaplanner$__field$__phoneNumber() {
        return this.phoneNumber;
    }

    public void $set$optaplanner$__field$__phoneNumber(String string) {
        this.phoneNumber = string;
    }

    public Set $get$optaplanner$__field$__requiredSkills() {
        return this.requiredSkills;
    }

    public void $set$optaplanner$__field$__requiredSkills(Set set) {
        this.requiredSkills = set;
    }

    public Duration $get$optaplanner$__field$__duration() {
        return this.duration;
    }

    public void $set$optaplanner$__field$__duration(Duration duration) {
        this.duration = duration;
    }

    public LocalTime $get$optaplanner$__field$__startTime() {
        return this.startTime;
    }

    public void $set$optaplanner$__field$__startTime(LocalTime localTime) {
        this.startTime = localTime;
    }

    public LocalTime $get$optaplanner$__field$__pickUpTime() {
        return this.pickUpTime;
    }

    public void $set$optaplanner$__field$__pickUpTime(LocalTime localTime) {
        this.pickUpTime = localTime;
    }
}

