/*
 * Decompiled with CFR 0.152.
 */
package org.acme.callcenter.service;

import java.time.Duration;
import java.time.LocalTime;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.acme.callcenter.data.DataGenerator;
import org.acme.callcenter.domain.Agent;
import org.acme.callcenter.domain.Call;
import org.acme.callcenter.domain.CallCenter;
import org.acme.callcenter.service.SimulationService;
import org.acme.callcenter.service.SolverService;

@ApplicationScoped
public class SimulationService {
    private static final int MAX_DURATION_SECONDS = 60;
    private static final int MIN_DURATION_SECONDS = 10;
    private static final int MAX_FREQUENCY_PER_MINUTE = 60;
    private final ScheduledExecutorService scheduledExecutorService;
    private final SolverService solverService;
    private final DataGenerator dataGenerator;
    private final ConcurrentMap<Long, CallInProgress> callsInProgress;
    private final AtomicBoolean running;
    private int durationSeconds;
    private int frequencyPerMinute;
    private ScheduledFuture<?> addNewCallScheduledFuture;

    public SimulationService() {
    }

    @Inject
    public SimulationService(SolverService solverService, DataGenerator dataGenerator) {
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.callsInProgress = new ConcurrentHashMap<Long, CallInProgress>();
        this.running = new AtomicBoolean(false);
        this.durationSeconds = 30;
        this.frequencyPerMinute = 25;
        this.solverService = solverService;
        this.dataGenerator = dataGenerator;
    }

    private ScheduledFuture<?> scheduleCallEnd(Call call, long delay, TimeUnit timeUnit) {
        return this.scheduledExecutorService.schedule(() -> this.callsInProgress.computeIfPresent(call.getId(), (callId, callInProgress) -> {
            this.solverService.removeCall((long)callId);
            return null;
        }), delay, timeUnit);
    }

    public void restartSimulation(int frequencyPerMinute, int durationSeconds) {
        if (frequencyPerMinute < 0 || frequencyPerMinute > 60) {
            throw new IllegalArgumentException("FrequencyPerMinute (" + frequencyPerMinute + ") must be between 0 and 60.");
        }
        if (durationSeconds < 10 || durationSeconds > 60) {
            throw new IllegalArgumentException("DurationSeconds (" + durationSeconds + ") must be between 10 and 60.");
        }
        if (this.running.get()) {
            this.stopSimulation();
            this.startSimulation(frequencyPerMinute, durationSeconds);
        }
        this.frequencyPerMinute = frequencyPerMinute;
        this.durationSeconds = durationSeconds;
    }

    public void startSimulation() {
        this.startSimulation(this.frequencyPerMinute, this.durationSeconds);
    }

    private void startSimulation(int frequency, int duration) {
        if (this.running.getAndSet(true)) {
            return;
        }
        if (frequency == 0) {
            return;
        }
        int delayInSeconds = 60 / frequency;
        this.addNewCallScheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(() -> this.solverService.addCall(this.dataGenerator.generateCall(duration)), 0L, delayInSeconds, TimeUnit.SECONDS);
    }

    public void stopSimulation() {
        this.running.set(false);
        if (this.addNewCallScheduledFuture != null) {
            this.addNewCallScheduledFuture.cancel(true);
            this.addNewCallScheduledFuture = null;
        }
    }

    public void prolongCall(long callId) {
        this.callsInProgress.computeIfPresent(callId, (id, callInProgress) -> {
            callInProgress.scheduledCallEnd.cancel(true);
            Call call = callInProgress.call;
            Duration remaining = call.getDuration().minus(Duration.between(call.getPickUpTime(), LocalTime.now()));
            long nextCallEndSeconds = remaining.plusMinutes(1L).getSeconds();
            return new CallInProgress(call, this.scheduleCallEnd(call, nextCallEndSeconds, TimeUnit.SECONDS));
        });
    }

    public void onNewBestSolution(CallCenter newBestSolution) {
        newBestSolution.getCalls().forEach(call -> {
            if (call.getPreviousCallOrAgent() != null && call.getPreviousCallOrAgent() instanceof Agent) {
                this.callsInProgress.computeIfAbsent(call.getId(), callId -> {
                    ScheduledFuture<?> existingCallScheduledFuture = this.scheduleCallEnd((Call)call, call.getDuration().getSeconds(), TimeUnit.SECONDS);
                    call.setPickUpTime(LocalTime.now());
                    return new CallInProgress(call, existingCallScheduledFuture);
                });
            }
        });
    }
}

