/*
 * Decompiled with CFR 0.152.
 */
package org.acme.facilitylocation.domain;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.acme.facilitylocation.domain.Consumer;
import org.acme.facilitylocation.domain.Facility;
import org.acme.facilitylocation.domain.FacilityLocationConstraintConfiguration;
import org.acme.facilitylocation.domain.Location;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfigurationProvider;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.ProblemFactCollectionProperty;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;

@PlanningSolution
public class FacilityLocationProblem {
    @ProblemFactCollectionProperty
    @ValueRangeProvider(id="facilityRange")
    private List<Facility> facilities;
    @PlanningEntityCollectionProperty
    private List<Consumer> consumers;
    @PlanningScore
    private HardSoftLongScore score;
    @ConstraintConfigurationProvider
    private FacilityLocationConstraintConfiguration constraintConfiguration = new FacilityLocationConstraintConfiguration();
    private Location southWestCorner;
    private Location northEastCorner;

    public FacilityLocationProblem() {
    }

    public FacilityLocationProblem(List<Facility> facilities, List<Consumer> consumers, Location southWestCorner, Location northEastCorner) {
        this.facilities = facilities;
        this.consumers = consumers;
        this.southWestCorner = southWestCorner;
        this.northEastCorner = northEastCorner;
    }

    public static FacilityLocationProblem empty() {
        FacilityLocationProblem problem = new FacilityLocationProblem(Collections.emptyList(), Collections.emptyList(), new Location(-90.0, -180.0), new Location(90.0, 180.0));
        problem.setScore(HardSoftLongScore.ZERO);
        return problem;
    }

    public List<Facility> getFacilities() {
        return this.facilities;
    }

    public void setFacilities(List<Facility> facilities) {
        this.facilities = facilities;
    }

    public List<Consumer> getConsumers() {
        return this.consumers;
    }

    public void setConsumers(List<Consumer> consumers) {
        this.consumers = consumers;
    }

    public HardSoftLongScore getScore() {
        return this.score;
    }

    public void setScore(HardSoftLongScore score) {
        this.score = score;
    }

    public FacilityLocationConstraintConfiguration getConstraintConfiguration() {
        return this.constraintConfiguration;
    }

    public void setConstraintConfiguration(FacilityLocationConstraintConfiguration constraintConfiguration) {
        this.constraintConfiguration = constraintConfiguration;
    }

    public List<Location> getBounds() {
        return Arrays.asList(this.southWestCorner, this.northEastCorner);
    }

    public long getTotalCost() {
        return this.facilities.stream().filter(Facility::isUsed).mapToLong(Facility::getSetupCost).sum();
    }

    public long getPotentialCost() {
        return this.facilities.stream().mapToLong(Facility::getSetupCost).sum();
    }

    public String getTotalDistance() {
        long distance = this.consumers.stream().filter(Consumer::isAssigned).mapToLong(Consumer::distanceFromFacility).sum();
        return distance / 1000L + " km";
    }

    public String toString() {
        return "FacilityLocationProblem{facilities: " + this.facilities.size() + ", consumers: " + this.consumers.size() + ", score: " + this.score + "}";
    }
}

