/*
 * Decompiled with CFR 0.152.
 */
package org.acme.facilitylocation.domain;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape=JsonFormat.Shape.ARRAY)
public class Location {
    public static final double METERS_PER_DEGREE = 111000.0;
    public final double latitude;
    public final double longitude;

    public Location(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public String toString() {
        return String.format("[%.4fN, %.4fE]", this.latitude, this.longitude);
    }

    public long getDistanceTo(Location other) {
        double latitudeDiff = other.latitude - this.latitude;
        double longitudeDiff = other.longitude - this.longitude;
        return (long)Math.ceil(Math.sqrt(latitudeDiff * latitudeDiff + longitudeDiff * longitudeDiff) * 111000.0);
    }
}

