/*
 * Decompiled with CFR 0.152.
 */
package org.acme.facilitylocation.rest;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.acme.facilitylocation.domain.FacilityLocationProblem;
import org.acme.facilitylocation.persistence.FacilityLocationProblemRepository;
import org.acme.facilitylocation.rest.Status;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.solver.SolverManager;

@Path(value="/flp")
public class SolverResource {
    private static final long PROBLEM_ID = 0L;
    private final AtomicReference<Throwable> solverError = new AtomicReference();
    private final FacilityLocationProblemRepository repository;
    private final SolverManager<FacilityLocationProblem, Long> solverManager;
    private final ScoreManager<FacilityLocationProblem, HardSoftLongScore> scoreManager;

    public SolverResource(FacilityLocationProblemRepository repository, SolverManager<FacilityLocationProblem, Long> solverManager, ScoreManager<FacilityLocationProblem, HardSoftLongScore> scoreManager) {
        this.repository = repository;
        this.solverManager = solverManager;
        this.scoreManager = scoreManager;
    }

    private Status statusFromSolution(FacilityLocationProblem solution) {
        return new Status(solution, this.scoreManager.explainScore((Object)solution).getSummary(), this.solverManager.getSolverStatus((Object)0L));
    }

    @GET
    @Path(value="status")
    public Status status() {
        Optional.ofNullable(this.solverError.getAndSet(null)).ifPresent(throwable -> {
            throw new RuntimeException("Solver failed", (Throwable)throwable);
        });
        return this.statusFromSolution(this.repository.solution().orElse(FacilityLocationProblem.empty()));
    }

    @POST
    @Path(value="solve")
    public void solve() {
        Optional<FacilityLocationProblem> maybeSolution = this.repository.solution();
        maybeSolution.ifPresent(facilityLocationProblem -> this.solverManager.solveAndListen((Object)0L, id -> facilityLocationProblem, this.repository::update, (problemId, throwable) -> this.solverError.set((Throwable)throwable)));
    }

    @POST
    @Path(value="stopSolving")
    public void stopSolving() {
        this.solverManager.terminateEarly((Object)0L);
    }
}

